/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.matchers;

import com.gzoltar.internal.core.instr.matchers.IMatcher;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.CtField;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class PrefixMatcher
implements IMatcher {
    private List<String> prefix = new LinkedList<String>();

    public PrefixMatcher(String ... strings) {
        this.prefix.addAll(Arrays.asList(strings));
    }

    public PrefixMatcher(List<String> strings) {
        this.prefix.addAll(strings);
    }

    @Override
    public boolean matches(CtClass ctClass) {
        return this.matchesPrefix(ctClass.getName());
    }

    @Override
    public boolean matches(CtBehavior ctBehavior) {
        return this.matchesPrefix(ctBehavior.getName());
    }

    @Override
    public boolean matches(CtField ctField) {
        return this.matchesPrefix(ctField.getName());
    }

    private boolean matchesPrefix(String name) {
        for (String p : this.prefix) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return false;
    }
}

