/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.matchers;

import com.gzoltar.internal.core.instr.matchers.IMatcher;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.CtField;
import java.security.CodeSource;
import java.security.ProtectionDomain;

public class SourceLocationMatcher
implements IMatcher {
    private final boolean inclNoLocationClasses;
    private final String buildLocation;
    private final ProtectionDomain protectionDomain;

    public SourceLocationMatcher(boolean inclNoLocationClasses, String buildLocation, ProtectionDomain protectionDomain) {
        this.inclNoLocationClasses = inclNoLocationClasses;
        this.buildLocation = buildLocation.replace(" ", "%20");
        this.protectionDomain = protectionDomain;
    }

    @Override
    public boolean matches(CtClass ctClass) {
        return this.inclNoLocationClasses || this.hasSourceLocation(this.protectionDomain);
    }

    private boolean hasSourceLocation(ProtectionDomain protectionDomain) {
        if (protectionDomain == null) {
            return false;
        }
        CodeSource codeSource = protectionDomain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        if (codeSource.getLocation() == null) {
            return false;
        }
        return codeSource.getLocation().getPath().startsWith(this.buildLocation);
    }

    @Override
    public boolean matches(CtBehavior ctBehavior) {
        return this.matches(ctBehavior.getDeclaringClass());
    }

    @Override
    public boolean matches(CtField ctField) {
        return this.matches(ctField.getDeclaringClass());
    }
}

