/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.pass;

import com.gzoltar.internal.core.instr.Outcome;
import com.gzoltar.internal.core.instr.filter.EmptyMethodFilter;
import com.gzoltar.internal.core.instr.pass.IPass;
import com.gzoltar.internal.core.runtime.Collector;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.CtMethod;

public abstract class AbstractInitMethodInstrumentationPass
implements IPass {
    private static final String METHOD_STR = "void $gzoltarInit() { if ($gzoltarData == null) { Object[] $tmpGZoltarData = new Object[] { \"%s\",\"%s\",\"%d\" }; %s $gzoltarData = (boolean[] ) $tmpGZoltarData[0]; }}";
    protected static final String ARRAY_OBJECT_NAME = "$tmpGZoltarData";
    private final EmptyMethodFilter emptyMethodFilter = new EmptyMethodFilter();
    private String classHash = null;
    protected String collectorCall = null;

    @Override
    public Outcome transform(CtClass ctClass) throws Exception {
        CtMethod gzoltarInit = CtMethod.make(String.format(METHOD_STR, this.classHash, ctClass.getName(), Collector.instance().getProbeGroupByHash(this.classHash).getNumberOfProbes(), this.collectorCall), ctClass);
        gzoltarInit.setModifiers(gzoltarInit.getModifiers() | 0x100A);
        ctClass.addMethod(gzoltarInit);
        return Outcome.ACCEPT;
    }

    @Override
    public Outcome transform(CtClass ctClass, CtBehavior ctBehavior) throws Exception {
        if (this.emptyMethodFilter.filter(ctBehavior) == Outcome.REJECT) {
            return Outcome.REJECT;
        }
        ctBehavior.insertBefore("$gzoltarInit();");
        return Outcome.ACCEPT;
    }

    public void setHash(String hash) {
        this.classHash = hash;
    }
}

