/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.instr.pass;

import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.instr.InstrumentationLevel;
import com.gzoltar.internal.core.instr.Outcome;
import com.gzoltar.internal.core.instr.filter.DuplicateCollectorReferenceFilter;
import com.gzoltar.internal.core.instr.filter.EmptyMethodFilter;
import com.gzoltar.internal.core.instr.filter.EnumFilter;
import com.gzoltar.internal.core.instr.filter.IFilter;
import com.gzoltar.internal.core.instr.filter.SyntheticFilter;
import com.gzoltar.internal.core.instr.pass.AbstractInitMethodInstrumentationPass;
import com.gzoltar.internal.core.instr.pass.FieldInstrumentationPass;
import com.gzoltar.internal.core.instr.pass.IPass;
import com.gzoltar.internal.core.instr.pass.InitMethodInstrumentationPass;
import com.gzoltar.internal.core.instr.pass.OfflineInitMethodInstrumentationPass;
import com.gzoltar.internal.core.instr.pass.StackSizePass;
import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.model.NodeFactory;
import com.gzoltar.internal.core.runtime.Collector;
import com.gzoltar.internal.core.runtime.Probe;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.core.util.MD5;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.CtConstructor;
import com.gzoltar.internal.javassist.bytecode.Bytecode;
import com.gzoltar.internal.javassist.bytecode.CodeAttribute;
import com.gzoltar.internal.javassist.bytecode.CodeIterator;
import com.gzoltar.internal.javassist.bytecode.ConstPool;
import com.gzoltar.internal.javassist.bytecode.MethodInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class InstrumentationPass
implements IPass {
    private final InstrumentationLevel instrumentationLevel;
    private final FieldInstrumentationPass fieldPass = new FieldInstrumentationPass();
    private AbstractInitMethodInstrumentationPass initMethodPass = null;
    private final StackSizePass stackSizePass = new StackSizePass();
    private final DuplicateCollectorReferenceFilter duplicateCollectorFilter = new DuplicateCollectorReferenceFilter();
    private final List<IFilter> filters = new ArrayList<IFilter>();
    private final Set<Integer> uniqueLineNumbers = new LinkedHashSet<Integer>();
    private ProbeGroup probeGroup;

    public InstrumentationPass(AgentConfigs agentConfigs) {
        this.instrumentationLevel = agentConfigs.getInstrumentationLevel();
        switch (this.instrumentationLevel) {
            default: {
                this.initMethodPass = new InitMethodInstrumentationPass();
                break;
            }
            case OFFLINE: {
                this.initMethodPass = new OfflineInitMethodInstrumentationPass();
            }
            case NONE: 
        }
        this.filters.add(new SyntheticFilter());
        this.filters.add(new EnumFilter());
        this.filters.add(new EmptyMethodFilter());
    }

    @Override
    public synchronized Outcome transform(CtClass ctClass) throws Exception {
        boolean instrumented = false;
        this.uniqueLineNumbers.clear();
        byte[] originalBytes = ctClass.toBytecode();
        ctClass.defrost();
        String hash = MD5.calculateHash(originalBytes);
        this.probeGroup = new ProbeGroup(hash, ctClass);
        for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
            boolean behaviorInstrumented = !this.transform(ctClass, ctBehavior).equals((Object)Outcome.REJECT);
            boolean bl = instrumented = instrumented || behaviorInstrumented;
            if (!behaviorInstrumented) continue;
            this.stackSizePass.transform(ctClass, ctBehavior);
        }
        Collector.instance().regiterProbeGroup(this.probeGroup);
        if (instrumented && this.initMethodPass != null) {
            this.fieldPass.transform(ctClass);
            this.initMethodPass.setHash(hash);
            this.initMethodPass.transform(ctClass);
            boolean hasAnyStaticInitializerBeenInstrumented = false;
            for (CtBehavior ctBehavior : ctClass.getDeclaredBehaviors()) {
                if (ctBehavior.getName().equals("$gzoltarInit")) continue;
                this.initMethodPass.transform(ctClass, ctBehavior);
                if (hasAnyStaticInitializerBeenInstrumented || !ctBehavior.getMethodInfo2().isStaticInitializer()) continue;
                hasAnyStaticInitializerBeenInstrumented = true;
            }
            if (!hasAnyStaticInitializerBeenInstrumented) {
                CtConstructor clinit = ctClass.makeClassInitializer();
                this.initMethodPass.transform(ctClass, clinit);
            }
        }
        return Outcome.ACCEPT;
    }

    @Override
    public Outcome transform(CtClass ctClass, CtBehavior ctBehavior) throws Exception {
        Outcome instrumented = Outcome.REJECT;
        for (IFilter filter : this.filters) {
            switch (filter.filter(ctBehavior)) {
                case REJECT: {
                    return instrumented;
                }
            }
        }
        MethodInfo methodInfo = ctBehavior.getMethodInfo();
        CodeAttribute ca = methodInfo.getCodeAttribute();
        if (ca == null) {
            return instrumented;
        }
        CodeIterator ci = ca.iterator();
        while (ci.hasNext()) {
            int index = ci.next();
            int curLine = methodInfo.getLineNumber(index);
            if (!(curLine == -1 || this.uniqueLineNumbers.contains(curLine) || methodInfo.isConstructor() && curLine == 1)) {
                Node node = NodeFactory.createNode(ctClass, ctBehavior, curLine);
                assert (node != null);
                Probe probe = this.probeGroup.registerProbe(node, ctBehavior);
                assert (probe != null);
                if (this.duplicateCollectorFilter.filter(ctClass) == Outcome.ACCEPT && (this.instrumentationLevel == InstrumentationLevel.FULL || this.instrumentationLevel == InstrumentationLevel.OFFLINE)) {
                    Bytecode bc = this.getInstrumentationCode(ctClass, probe, methodInfo.getConstPool());
                    ci.insert(index, bc.get());
                    instrumented = Outcome.ACCEPT;
                } else {
                    instrumented = Outcome.REJECT;
                }
            }
            this.uniqueLineNumbers.add(curLine);
        }
        return instrumented;
    }

    private Bytecode getInstrumentationCode(CtClass ctClass, Probe probe, ConstPool constPool) {
        Bytecode b = new Bytecode(constPool);
        b.addGetstatic(ctClass, "$gzoltarData", "[Z");
        b.addIconst(probe.getArrayIndex());
        b.addOpcode(4);
        b.addOpcode(84);
        return b;
    }
}

