/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.listeners;

import com.gzoltar.internal.core.model.TransactionOutcome;
import com.gzoltar.internal.core.runtime.Collector;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.junit.runner.notification.RunListener;

public class Listener
extends RunListener {
    public static final String TEST_CLASS_NAME_SEPARATOR = "#";
    private boolean hasFailed = false;
    private long startTime;
    protected String stackTrace;

    public final void onRunStart() {
    }

    public final void onRunFinish() {
        Collector.instance().endSession();
    }

    public final void onTestStart() {
        this.hasFailed = false;
        this.startTime = System.nanoTime();
        this.stackTrace = "";
    }

    public final void onTestFinish(String testName) {
        Collector.instance().endTransaction(testName, this.hasFailed ? TransactionOutcome.FAIL : TransactionOutcome.PASS, System.nanoTime() - this.startTime, this.stackTrace);
    }

    public final void onTestFailure(String trace) {
        this.hasFailed = true;
        this.stackTrace = trace;
    }

    public final void onTestSkipped() {
    }

    protected final String traceToString(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        exception.printStackTrace(writer);
        return stringWriter.toString();
    }
}

