/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.messaging;

import com.gzoltar.internal.core.events.IEventListener;
import com.gzoltar.internal.core.messaging.Message;
import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;

public class Client
implements IEventListener {
    private final String host;
    private final int port;
    private final String id;
    private final Queue<Message> messages;
    private Boolean seenByeMessage = false;
    private Socket socket = null;
    private Thread thread = null;

    public Client(String host, int port) {
        this.host = host;
        this.port = port;
        this.id = UUID.randomUUID().toString();
        this.messages = new LinkedList<Message>();
    }

    public Client(int port) {
        this(null, port);
    }

    private synchronized Thread postMessage(Message m) {
        this.messages.add(m);
        if (this.thread == null) {
            this.thread = new Thread(new ClientDispatcher());
            this.thread.start();
        }
        return this.thread;
    }

    private void postBlockingMessage(Message m) {
        try {
            this.postMessage(new Message.ByeMessage()).join(5000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized Message getMessage() {
        if (this.messages.size() == 0) {
            this.thread = null;
            return null;
        }
        return this.messages.poll();
    }

    @Override
    public void regiterProbeGroup(ProbeGroup probeGroup) {
        this.postMessage(new Message.AddProbeGroupMessage(probeGroup));
    }

    @Override
    public void endTransaction(Transaction transaction) {
        this.postMessage(new Message.EndTransactionMessage(transaction));
    }

    @Override
    public void endSession() {
        this.postBlockingMessage(new Message.ByeMessage());
    }

    private class ClientDispatcher
    implements Runnable {
        private ClientDispatcher() {
        }

        @Override
        public void run() {
            Message message = Client.this.getMessage();
            while (message != null) {
                try {
                    ObjectOutputStream out;
                    if (Client.this.socket == null) {
                        Client.this.socket = new Socket(Client.this.host, Client.this.port);
                        out = new ObjectOutputStream(Client.this.socket.getOutputStream());
                        out.writeObject(new Message.HandshakeMessage(Client.this.id));
                        out.flush();
                    }
                    if (!Client.this.seenByeMessage.booleanValue()) {
                        Client.this.seenByeMessage = Client.this.seenByeMessage | message instanceof Message.ByeMessage;
                        out = new ObjectOutputStream(Client.this.socket.getOutputStream());
                        out.writeObject(message);
                        out.flush();
                    }
                    message = Client.this.getMessage();
                }
                catch (Exception e) {
                    System.err.println("Exception, reseting socket");
                    e.printStackTrace();
                    Client.this.socket = null;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception e2) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

