/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.messaging;

import com.gzoltar.internal.core.events.IEventListener;
import com.gzoltar.internal.core.messaging.Message;
import com.gzoltar.internal.core.messaging.Service;
import com.gzoltar.internal.core.messaging.ThreadedServer;
import java.io.ObjectInputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class Server
extends ThreadedServer {
    private Service.ServiceFactory serviceFactory;

    public Server(ServerSocket serverSocket, Service.ServiceFactory serviceFactory) {
        super(serverSocket);
        this.serviceFactory = serviceFactory;
    }

    @Override
    protected final Runnable handle(Socket s) {
        return new ServerDispatcher(s);
    }

    private class ServerDispatcher
    implements Runnable {
        private Socket socket;
        private Service service;

        public ServerDispatcher(Socket s) {
            this.socket = s;
        }

        @Override
        public void run() {
            try {
                Object o;
                this.service = this.handshake();
                while (!this.dispatch(o = new ObjectInputStream(this.socket.getInputStream()).readObject())) {
                }
                this.service.terminated();
            }
            catch (Throwable e) {
                if (this.service != null) {
                    this.service.interrupted();
                }
                e.printStackTrace();
            }
            try {
                this.socket.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public Service handshake() throws Exception {
            Object o = new ObjectInputStream(this.socket.getInputStream()).readObject();
            if (!(o instanceof Message.HandshakeMessage)) {
                throw new Exception("First message should be a HandshakeMessage. Received instead: " + o);
            }
            String id = ((Message.HandshakeMessage)o).id;
            return Server.this.serviceFactory.create(id);
        }

        private boolean dispatch(Object o) {
            IEventListener eventListener = this.service.getEventListener();
            if (o instanceof Message.ByeMessage) {
                eventListener.endSession();
                return true;
            }
            if (o instanceof Message.EndTransactionMessage) {
                Message.EndTransactionMessage etm = (Message.EndTransactionMessage)o;
                eventListener.endTransaction(etm.transaction);
            } else if (o instanceof Message.AddProbeGroupMessage) {
                Message.AddProbeGroupMessage anm = (Message.AddProbeGroupMessage)o;
                eventListener.regiterProbeGroup(anm.probeGroup);
            }
            return false;
        }
    }
}

