/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.model;

import com.gzoltar.internal.core.model.NodeType;
import com.gzoltar.internal.org.apache.commons.lang3.builder.EqualsBuilder;
import com.gzoltar.internal.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Node {
    private String name;
    private final int lineNumber;
    private NodeType type;
    private int depth;
    private Node parent;
    private final Map<String, Node> children = new LinkedHashMap<String, Node>();
    private Map<String, Double> suspiciousnessValues = null;

    public Node(String name, int lineNumber, NodeType type) {
        this(name, lineNumber, type, null);
    }

    public Node(String name, int lineNumber, NodeType type, Node parent) {
        this.type = type;
        this.name = name;
        this.lineNumber = lineNumber;
        this.setParent(parent);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        if (this.type == NodeType.METHOD) {
            String str = this.name.substring(0, this.name.indexOf(40));
            return str;
        }
        return this.getName();
    }

    public String getNameWithLineNumber() {
        return this.getName() + (this.type != NodeType.LINE ? NodeType.LINE.getSymbol() + this.lineNumber : "");
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public NodeType getNodeType() {
        return this.type;
    }

    public void setNodeType(NodeType type) {
        this.type = type;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setParent(Node parent) {
        this.parent = parent;
        if (this.parent == null) {
            this.depth = 0;
        } else {
            this.depth = this.parent.getDepth() + 1;
            if (!this.parent.children.containsKey(this.name)) {
                this.parent.children.put(this.name, this);
            }
        }
    }

    public Node getParent() {
        return this.parent;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public List<Node> getChildren() {
        return new ArrayList<Node>(this.children.values());
    }

    public Node getChild(String name) {
        return this.children.get(name);
    }

    public boolean hasChildrenOfType(NodeType type) {
        for (Node child : this.children.values()) {
            if (child.type != type) continue;
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public List<Node> getLeafNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.getLeafNodes(nodes);
        return nodes;
    }

    private void getLeafNodes(List<Node> nodes) {
        if (this.isLeaf()) {
            nodes.add(this);
        } else {
            for (Node child : this.children.values()) {
                child.getLeafNodes(nodes);
            }
        }
    }

    public void addSuspiciousnessValue(String formulaName, Double suspiciousnessValue) {
        if (this.suspiciousnessValues == null) {
            this.suspiciousnessValues = new LinkedHashMap<String, Double>();
        }
        this.suspiciousnessValues.put(formulaName, suspiciousnessValue);
    }

    public boolean hasSuspiciousnessValues() {
        if (this.suspiciousnessValues == null) {
            return false;
        }
        return !this.suspiciousnessValues.isEmpty();
    }

    public Map<String, Double> getSuspiciousnessValues() {
        return this.suspiciousnessValues;
    }

    public Double getSuspiciousnessValue(String formulaName) {
        if (this.suspiciousnessValues == null && !this.children.isEmpty()) {
            Double maxSuspiciousnessValue = -4.9E-324;
            for (Node child : this.children.values()) {
                maxSuspiciousnessValue = Math.max(maxSuspiciousnessValue, child.getSuspiciousnessValue(formulaName));
            }
            return maxSuspiciousnessValue;
        }
        assert (this.suspiciousnessValues != null);
        assert (this.suspiciousnessValues.containsKey(formulaName));
        return this.suspiciousnessValues.get(formulaName);
    }

    public int getNumberOfSuspiciousnessValues() {
        assert (this.suspiciousnessValues != null);
        return this.suspiciousnessValues.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.isLeaf() ? "[probe] " : "");
        sb.append(this.getNameWithLineNumber());
        if (this.hasSuspiciousnessValues()) {
            sb.append("  [ ");
            for (Map.Entry<String, Double> suspiciousness : this.suspiciousnessValues.entrySet()) {
                sb.append(suspiciousness.getKey() + ":" + suspiciousness.getValue() + " ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append(this.name);
        builder.append(this.lineNumber);
        builder.append(this.depth);
        builder.append(this.parent);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node node = (Node)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.type, (Object)node.type);
        builder.append(this.name, node.name);
        builder.append(this.lineNumber, node.lineNumber);
        builder.append(this.depth, node.depth);
        builder.append(this.parent, node.parent);
        return builder.isEquals();
    }
}

