/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.model;

import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.model.NodeType;
import com.gzoltar.internal.core.model.Tree;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.bytecode.Descriptor;

public final class NodeFactory {
    public static Node createNode(CtClass ctClass, CtBehavior ctBehavior, int lineNumber) {
        String packageName = ctClass.getPackageName() == null ? "" : ctClass.getPackageName();
        StringBuilder className = new StringBuilder(packageName);
        className.append(NodeType.CLASS.getSymbol());
        className.append(ctClass.getSimpleName());
        StringBuilder methodName = className;
        methodName.append(NodeType.METHOD.getSymbol());
        methodName.append(ctBehavior.getName());
        methodName.append(Descriptor.toString(ctBehavior.getSignature()));
        StringBuilder lineName = methodName;
        lineName.append(NodeType.LINE.getSymbol());
        lineName.append(String.valueOf(lineNumber));
        return new Node(lineName.toString(), lineNumber, NodeType.LINE);
    }

    public static void createNode(Tree tree, Node node) {
        String nodeName = node.getName();
        NodeType nodeType = node.getNodeType();
        int lineNumber = node.getLineNumber();
        String packageName = nodeName.substring(0, nodeType.equals((Object)NodeType.PACKAGE) ? nodeName.indexOf(NodeType.LINE.getSymbol()) : nodeName.indexOf(NodeType.CLASS.getSymbol()));
        Node packageNode = tree.getNode(packageName);
        if (packageNode == null) {
            packageNode = new Node(packageName, lineNumber, NodeType.PACKAGE, tree.getRoot());
            tree.addNode(packageNode);
        }
        if (nodeType.equals((Object)NodeType.CLASS)) {
            node.setParent(packageNode);
            tree.addNode(node);
            return;
        }
        String className = nodeName.substring(0, nodeType.equals((Object)NodeType.CLASS) ? nodeName.indexOf(NodeType.LINE.getSymbol()) : nodeName.indexOf(NodeType.METHOD.getSymbol()));
        Node classNode = tree.getNode(className);
        if (classNode == null) {
            classNode = new Node(className, lineNumber, NodeType.CLASS, packageNode);
            tree.addNode(classNode);
        }
        if (nodeType.equals((Object)NodeType.METHOD)) {
            node.setParent(classNode);
            tree.addNode(node);
            return;
        }
        String methodName = nodeName.substring(0, nodeName.indexOf(NodeType.LINE.getSymbol()));
        Node methodNode = tree.getNode(methodName);
        if (methodNode == null) {
            methodNode = new Node(methodName, lineNumber, NodeType.METHOD, classNode);
            tree.addNode(methodNode);
        }
        node.setParent(methodNode);
        tree.addNode(node);
    }
}

