/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.model;

import com.gzoltar.internal.core.model.TransactionOutcome;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.org.apache.commons.lang3.builder.EqualsBuilder;
import com.gzoltar.internal.org.apache.commons.lang3.builder.HashCodeBuilder;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.Pair;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class Transaction {
    private final String name;
    private final Map<String, Pair<String, boolean[]>> activity;
    private final TransactionOutcome outcome;
    private final long runtime;
    private final String stackTrace;

    public Transaction(String name, TransactionOutcome outcome, long runtime, String stackTrace) {
        this(name, new LinkedHashMap<String, Pair<String, boolean[]>>(), outcome, runtime, stackTrace);
    }

    public Transaction(String name, Map<String, Pair<String, boolean[]>> activity, TransactionOutcome outcome, long runtime, String stackTrace) {
        this.name = name;
        this.activity = activity;
        this.outcome = outcome;
        this.runtime = runtime;
        this.stackTrace = this.getNormalizedStackTrace(stackTrace);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getProbeGroupsHash() {
        return this.activity.keySet();
    }

    public boolean hasActivations() {
        return !this.activity.isEmpty();
    }

    public Map<String, Pair<String, boolean[]>> getActivity() {
        return this.activity;
    }

    public void addActivity(String hash, Pair<String, boolean[]> hitArray) {
        this.activity.put(hash, hitArray);
    }

    public boolean[] getHitArray(ProbeGroup probeGroup) {
        return this.activity.get(probeGroup.getHash()).getRight();
    }

    public boolean[] getHitArrayByProbeGroupHash(String hash) {
        return this.activity.get(hash).getRight();
    }

    public boolean isProbeActived(ProbeGroup probeGroup, int probeIndex) {
        if (!this.activity.containsKey(probeGroup.getHash())) {
            return false;
        }
        return this.activity.get(probeGroup.getHash()).getRight()[probeIndex];
    }

    public TransactionOutcome getTransactionOutcome() {
        return this.outcome;
    }

    public boolean hasFailed() {
        return this.outcome.equals((Object)TransactionOutcome.FAIL);
    }

    public long getRuntime() {
        return this.runtime;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    private String getNormalizedStackTrace(String stackStrace) {
        if (stackStrace == null || stackStrace.isEmpty()) {
            return "";
        }
        String normalizedString = stackStrace.replaceAll(" *\r?\n[ \t]*", " ").replaceAll("^[ \t\r\n]*|[ \t\r\n]*$", "");
        Charset utf8 = Charset.forName(StandardCharsets.UTF_8.name());
        int maxNumBytes = 65534;
        byte[] normalizedStringBytes = normalizedString.getBytes(utf8);
        if (normalizedStringBytes.length <= maxNumBytes) {
            return normalizedString;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(normalizedStringBytes, 0, maxNumBytes);
        CharBuffer charBuffer = CharBuffer.allocate(normalizedString.length());
        CharsetDecoder decoder = utf8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.IGNORE);
        decoder.decode(byteBuffer, charBuffer, true);
        decoder.flush(charBuffer);
        return new String(charBuffer.array(), 0, charBuffer.position());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ProbeGroup] ");
        sb.append(this.name);
        sb.append("\n");
        sb.append("  Executed ");
        sb.append(this.activity.size());
        sb.append(" probeGroups");
        sb.append("\n");
        sb.append("  Pass/Fail ");
        if (this.hasFailed()) {
            sb.append(TransactionOutcome.FAIL.getSymbol());
        } else {
            sb.append(TransactionOutcome.PASS.getSymbol());
        }
        sb.append("\n");
        sb.append("  Hashcode: ");
        sb.append(this.hashCode());
        return sb.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.name);
        builder.append(this.activity);
        builder.append((Object)this.outcome);
        builder.append(this.runtime);
        builder.append(this.stackTrace);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction transaction = (Transaction)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.name, transaction.name);
        builder.append(this.activity, transaction.activity);
        builder.append(this.runtime, transaction.runtime);
        builder.append((Object)this.outcome, (Object)transaction.outcome);
        builder.append(this.stackTrace, transaction.stackTrace);
        return builder.isEquals();
    }
}

