/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.model;

import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.model.NodeType;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.org.apache.commons.lang3.builder.EqualsBuilder;
import com.gzoltar.internal.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Tree
implements Iterable<Node> {
    public static final String ROOT_NAME = "root";
    private Node root = null;
    private final Map<String, Node> nodes = new LinkedHashMap<String, Node>();

    public Tree() {
        this(true);
    }

    public Tree(boolean createRoot) {
        if (createRoot) {
            this.root = new Node(ROOT_NAME, -1, NodeType.PACKAGE, null);
            this.nodes.put(ROOT_NAME, this.root);
        }
    }

    public void addNode(Node node) {
        if (!this.nodes.containsKey(node.getName())) {
            this.nodes.put(node.getName(), node);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public Node getNode(String name) {
        return this.nodes.get(name);
    }

    public List<Node> getTargetNodes() {
        return Collections.unmodifiableList(this.getRoot().getLeafNodes());
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(new ArrayList<Node>(this.nodes.values()));
    }

    public List<Node> getNodesOfType(NodeType type) {
        ArrayList<Node> nodesOfType = new ArrayList<Node>();
        for (Node node : this.nodes.values()) {
            if (!node.getNodeType().equals((Object)type)) continue;
            nodesOfType.add(node);
        }
        return nodesOfType;
    }

    public int getNumberOfTargetNodes() {
        return this.getRoot().getLeafNodes().size();
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    @Override
    public Iterator<Node> iterator() {
        return this.nodes.values().iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("~~~~~~~~~~\n");
        Node root = this.getRoot();
        this.toString(stringBuilder, root, "");
        stringBuilder.append("~~~~~~~~~~\n");
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder, Node node, String padding) {
        stringBuilder.append(padding + node.toString() + "\n");
        for (Node child : node.getChildren()) {
            this.toString(stringBuilder, child, padding + "  ");
        }
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.nodes);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeGroup)) {
            return false;
        }
        Tree probeGroup = (Tree)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.nodes, probeGroup.nodes);
        return builder.isEquals();
    }
}

