/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.runtime;

import com.gzoltar.internal.core.events.IEventListener;
import com.gzoltar.internal.core.events.MultiEventListener;
import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.model.TransactionOutcome;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.core.spectrum.Spectrum;
import com.gzoltar.internal.core.util.ArrayUtils;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.ImmutablePair;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.Pair;
import java.util.LinkedHashMap;
import java.util.Map;

public class Collector {
    private static Collector collector;
    private MultiEventListener listener = new MultiEventListener(new IEventListener[0]);
    private final Spectrum spectrum = new Spectrum();
    private final Map<String, Pair<String, boolean[]>> hitArrays = new LinkedHashMap<String, Pair<String, boolean[]>>();

    public static Collector instance() {
        if (collector == null) {
            collector = new Collector();
        }
        return collector;
    }

    public static void restart() {
        if (collector != null) {
            Collector newCollector = new Collector();
            newCollector.listener = Collector.collector.listener;
            collector = newCollector;
        }
    }

    private Collector() {
    }

    public void addListener(IEventListener listener) {
        if (listener != null) {
            this.listener.add(listener);
        }
    }

    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    public synchronized void regiterProbeGroup(ProbeGroup probeGroup) {
        if (probeGroup.isEmpty()) {
            return;
        }
        this.spectrum.addProbeGroup(probeGroup);
        this.listener.regiterProbeGroup(probeGroup);
    }

    public synchronized ProbeGroup getProbeGroup(ProbeGroup probeGroup) {
        return this.spectrum.getProbeGroup(probeGroup);
    }

    public synchronized ProbeGroup getProbeGroupByHash(String probeGroupHash) {
        return this.spectrum.getProbeGroupByHash(probeGroupHash);
    }

    public synchronized void endTransaction(String transactionName, TransactionOutcome outcome, long runtime, String stackTrace) {
        LinkedHashMap<String, Pair<String, boolean[]>> activity = new LinkedHashMap<String, Pair<String, boolean[]>>();
        for (Map.Entry<String, Pair<String, boolean[]>> entry : this.hitArrays.entrySet()) {
            boolean[] hitArray = entry.getValue().getRight();
            if (!ArrayUtils.containsValue(hitArray, true)) continue;
            String hash = entry.getKey();
            boolean[] cloneHitArray = new boolean[hitArray.length];
            System.arraycopy(hitArray, 0, cloneHitArray, 0, hitArray.length);
            activity.put(hash, new ImmutablePair<String, boolean[]>(entry.getValue().getLeft(), cloneHitArray));
            for (int i = 0; i < hitArray.length; ++i) {
                hitArray[i] = false;
            }
        }
        Transaction transaction = new Transaction(transactionName, activity, outcome, runtime, stackTrace);
        this.spectrum.addTransaction(transaction);
        this.listener.endTransaction(transaction);
    }

    public synchronized void endSession() {
        this.listener.endSession();
    }

    public synchronized void getHitArray(Object[] args) {
        assert (args.length == 3);
        String hash = (String)args[0];
        String probeGroupName = (String)args[1];
        Integer numberOfProbes = Integer.valueOf((String)args[2]);
        if (!this.hitArrays.containsKey(hash)) {
            this.hitArrays.put(hash, new ImmutablePair<String, boolean[]>(probeGroupName, new boolean[numberOfProbes.intValue()]));
        }
        args[0] = this.hitArrays.get(hash).getRight();
    }

    public boolean equals(Object args) {
        if (args instanceof Object[]) {
            this.getHitArray((Object[])args);
        }
        return super.equals(args);
    }
}

