/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.runtime;

import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.runtime.Probe;
import com.gzoltar.internal.javassist.CtBehavior;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.org.apache.commons.lang3.builder.EqualsBuilder;
import com.gzoltar.internal.org.apache.commons.lang3.builder.HashCodeBuilder;
import java.util.ArrayList;
import java.util.List;

public final class ProbeGroup {
    private final String hash;
    private final CtClass ctClass;
    private final List<Probe> probes;

    public ProbeGroup(String hash, CtClass ctClass) {
        this(hash, ctClass, new ArrayList<Probe>());
    }

    public ProbeGroup(String hash, CtClass ctClass, List<Probe> probes) {
        this.hash = hash;
        this.ctClass = ctClass;
        this.probes = probes;
    }

    public String getHash() {
        return this.hash;
    }

    public CtClass getCtClass() {
        return this.ctClass;
    }

    public String getName() {
        return this.ctClass.getName();
    }

    public Probe registerProbe(Node node, CtBehavior ctBehavior) {
        Probe probe = new Probe(this.probes.size(), node, ctBehavior);
        this.probes.add(probe);
        return probe;
    }

    public List<Probe> getProbes() {
        return this.probes;
    }

    public int getNumberOfProbes() {
        return this.probes.size();
    }

    public boolean isEmpty() {
        return this.probes.isEmpty();
    }

    public Probe findProbeByNode(Node node) {
        for (Probe probe : this.probes) {
            if (!probe.getNode().equals(node)) continue;
            return probe;
        }
        return null;
    }

    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Probe probe : this.probes) {
            nodes.add(probe.getNode());
        }
        return nodes;
    }

    public Node getNode(String nodeName) {
        for (Probe probe : this.probes) {
            if (!probe.getNode().getName().equals(nodeName)) continue;
            return probe.getNode();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ProbeGroup] ");
        sb.append(this.hash);
        sb.append(" | ");
        sb.append(this.getName());
        for (Probe probe : this.probes) {
            sb.append("\n");
            sb.append(probe.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.hash);
        builder.append(this.getName());
        builder.append(this.probes);
        return builder.toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProbeGroup)) {
            return false;
        }
        ProbeGroup probeGroup = (ProbeGroup)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.hash, probeGroup.hash);
        builder.append(this.getName(), probeGroup.getName());
        builder.append(this.probes, probeGroup.probes);
        return builder.isEquals();
    }
}

