/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.spectrum;

import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.instr.Outcome;
import com.gzoltar.internal.core.instr.actions.BlackList;
import com.gzoltar.internal.core.instr.actions.IAction;
import com.gzoltar.internal.core.instr.actions.WhiteList;
import com.gzoltar.internal.core.instr.filter.Filter;
import com.gzoltar.internal.core.instr.granularity.GranularityLevel;
import com.gzoltar.internal.core.instr.matchers.ClassNameMatcher;
import com.gzoltar.internal.core.instr.matchers.MethodAnnotationMatcher;
import com.gzoltar.internal.core.instr.matchers.MethodModifierMatcher;
import com.gzoltar.internal.core.instr.matchers.MethodNameMatcher;
import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.model.NodeType;
import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.runtime.Probe;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.core.spectrum.ISpectrum;
import com.gzoltar.internal.core.spectrum.Spectrum;
import com.gzoltar.internal.core.util.ArrayUtils;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.ImmutablePair;

public class FilteredSpectrum {
    private final GranularityLevel granularity;
    private final Filter classFilter;
    private final Filter methodFilter = new Filter(new IAction[0]);

    public FilteredSpectrum(AgentConfigs configs) {
        this.granularity = configs.getGranularity();
        WhiteList includeClasses = new WhiteList(new ClassNameMatcher(configs.getIncludes()));
        BlackList excludeClasses = new BlackList(new ClassNameMatcher(configs.getExcludes()));
        this.classFilter = new Filter(includeClasses, excludeClasses);
        if (!configs.getInclPublicMethods().booleanValue()) {
            this.methodFilter.add(new BlackList(new MethodModifierMatcher(1)));
        }
        if (!configs.getInclStaticConstructors().booleanValue()) {
            this.methodFilter.add(new BlackList(new MethodNameMatcher("<clinit>*")));
        }
        if (!configs.getInclDeprecatedMethods().booleanValue()) {
            this.methodFilter.add(new BlackList(new MethodAnnotationMatcher(Deprecated.class.getCanonicalName())));
        }
    }

    public ISpectrum filter(ISpectrum source) {
        if (source == null) {
            return null;
        }
        Spectrum filteredSpectrum = new Spectrum();
        for (ProbeGroup probeGroup : source.getProbeGroups()) {
            if (this.classFilter.filter(probeGroup.getCtClass()) == Outcome.REJECT) continue;
            ProbeGroup newProbeGroup = new ProbeGroup(probeGroup.getHash(), probeGroup.getCtClass());
            Filter granularityMethodFilter = new Filter(new IAction[0]);
            for (Probe probe : probeGroup.getProbes()) {
                if (this.methodFilter.filter(probe.getCtBehavior()) == Outcome.REJECT || granularityMethodFilter.filter(probe.getCtBehavior()) == Outcome.REJECT) continue;
                newProbeGroup.registerProbe(probe.getNode(), probe.getCtBehavior());
                if (this.granularity == GranularityLevel.CLASS) break;
                if (this.granularity != GranularityLevel.METHOD) continue;
                Node node = probe.getNode();
                String methodName = node.getName().substring(node.getName().indexOf(NodeType.METHOD.getSymbol()) + 1, node.getName().indexOf(NodeType.LINE.getSymbol()));
                granularityMethodFilter.add(new BlackList(new MethodNameMatcher(methodName)));
            }
            if (newProbeGroup.isEmpty()) continue;
            filteredSpectrum.addProbeGroup(newProbeGroup);
        }
        for (Transaction transaction : source.getTransactions()) {
            Transaction newTransaction = new Transaction(transaction.getName(), transaction.getTransactionOutcome(), transaction.getRuntime(), transaction.getStackTrace());
            for (String hash : transaction.getProbeGroupsHash()) {
                if (!filteredSpectrum.containsProbeGroupByHash(hash)) continue;
                ProbeGroup probeGroup = source.getProbeGroupByHash(hash);
                boolean[] hitArray = transaction.getHitArrayByProbeGroupHash(hash);
                ProbeGroup newProbeGroup = filteredSpectrum.getProbeGroupByHash(hash);
                boolean[] newHitArray = new boolean[newProbeGroup.getNumberOfProbes()];
                for (Probe probe : probeGroup.getProbes()) {
                    Probe newProbe = newProbeGroup.findProbeByNode(probe.getNode());
                    if (newProbe == null) continue;
                    newHitArray[newProbe.getArrayIndex()] = hitArray[probe.getArrayIndex()];
                }
                if (!ArrayUtils.containsValue(newHitArray, true)) continue;
                newTransaction.addActivity(hash, new ImmutablePair<String, boolean[]>(newProbeGroup.getName(), newHitArray));
            }
            filteredSpectrum.addTransaction(newTransaction);
        }
        if (this.granularity != GranularityLevel.LINE) {
            for (ProbeGroup probeGroup : filteredSpectrum.getProbeGroups()) {
                for (Probe probe : probeGroup.getProbes()) {
                    Node node = probe.getNode();
                    String newNodeName = null;
                    NodeType newNodeType = null;
                    switch (this.granularity) {
                        case CLASS: {
                            newNodeName = node.getName().substring(0, node.getName().indexOf(NodeType.METHOD.getSymbol()));
                            newNodeType = NodeType.CLASS;
                            break;
                        }
                        case METHOD: {
                            newNodeName = node.getName().substring(0, node.getName().indexOf(NodeType.LINE.getSymbol()));
                            newNodeType = NodeType.METHOD;
                            break;
                        }
                    }
                    if (newNodeName == null || newNodeType == null) continue;
                    node.setName(newNodeName);
                    node.setNodeType(newNodeType);
                }
            }
        }
        return filteredSpectrum;
    }
}

