/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.spectrum;

import com.gzoltar.internal.core.model.Node;
import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.runtime.Probe;
import com.gzoltar.internal.core.runtime.ProbeGroup;
import com.gzoltar.internal.core.spectrum.ISpectrum;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Spectrum
implements ISpectrum {
    private final Map<String, ProbeGroup> probeGroups = new LinkedHashMap<String, ProbeGroup>();
    private final List<Transaction> transactions = new ArrayList<Transaction>();

    @Override
    public void addProbeGroup(ProbeGroup probeGroup) {
        if (!this.probeGroups.containsKey(probeGroup.getHash())) {
            this.probeGroups.put(probeGroup.getHash(), probeGroup);
        }
    }

    @Override
    public boolean containsProbeGroup(ProbeGroup probeGroup) {
        return this.probeGroups.containsKey(probeGroup.getHash());
    }

    @Override
    public boolean containsProbeGroupByHash(String hash) {
        return this.probeGroups.containsKey(hash);
    }

    @Override
    public ProbeGroup getProbeGroup(ProbeGroup probeGroup) {
        return this.containsProbeGroup(probeGroup) ? this.probeGroups.get(probeGroup.getHash()) : null;
    }

    @Override
    public ProbeGroup getProbeGroupByHash(String hash) {
        return this.containsProbeGroupByHash(hash) ? this.probeGroups.get(hash) : null;
    }

    @Override
    public Collection<ProbeGroup> getProbeGroups() {
        return this.probeGroups.values();
    }

    @Override
    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (ProbeGroup probeGroup : this.probeGroups.values()) {
            nodes.addAll(probeGroup.getNodes());
        }
        return nodes;
    }

    @Override
    public int getNumberOfNodes() {
        return this.getNodes().size();
    }

    @Override
    public List<Node> getHitNodes(Transaction transaction) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry<String, Pair<String, boolean[]>> activity : transaction.getActivity().entrySet()) {
            String probeGroupHash = activity.getKey();
            ProbeGroup probeGroup = this.probeGroups.get(probeGroupHash);
            boolean[] hitArray = activity.getValue().getRight();
            assert (hitArray.length == probeGroup.getNumberOfProbes());
            for (Probe probe : probeGroup.getProbes()) {
                if (!hitArray[probe.getArrayIndex()]) continue;
                nodes.add(probe.getNode());
            }
        }
        return nodes;
    }

    @Override
    public void addTransaction(Transaction transaction) {
        if (transaction.hasActivations()) {
            this.transactions.add(transaction);
        }
    }

    @Override
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public int getNumberOfTransactions() {
        return this.transactions.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        List<Node> nodes = this.getNodes();
        for (Node node : nodes) {
            sb.append(node.toString());
            sb.append("\n");
        }
        for (Transaction transaction : this.transactions) {
            sb.append(transaction.toString());
            sb.append("\n");
        }
        sb.append("\nNumber of target nodes: " + this.getNumberOfNodes() + "\n");
        sb.append("Number of transactions: " + this.transactions.size() + "\n");
        return sb.toString();
    }
}

