/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.spectrum;

import com.gzoltar.internal.core.AgentConfigs;
import com.gzoltar.internal.core.instr.Instrumenter;
import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.model.TransactionOutcome;
import com.gzoltar.internal.core.runtime.Collector;
import com.gzoltar.internal.core.spectrum.Spectrum;
import com.gzoltar.internal.core.util.SerialisationIdentifiers;
import com.gzoltar.internal.javassist.ClassPool;
import com.gzoltar.internal.javassist.CtClass;
import com.gzoltar.internal.javassist.NotFoundException;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.ImmutablePair;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.Pair;
import com.gzoltar.internal.org.jacoco.core.internal.data.CompactDataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;

public class SpectrumReader {
    private final Spectrum spectrum;
    private final CompactDataInput in;
    private boolean firstBlock = true;
    private Instrumenter instrumenter = null;
    private final TransactionDeserialize transactionDeserialize = new TransactionDeserialize();

    public SpectrumReader(String buildLocation, AgentConfigs agentConfigs, InputStream input) {
        this.spectrum = Collector.instance().getSpectrum();
        this.in = new CompactDataInput(input);
        this.instrumenter = new Instrumenter(agentConfigs);
        try {
            ClassPool.getDefault().appendClassPath(buildLocation);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Spectrum getSpectrum() {
        return this.spectrum;
    }

    public boolean read() throws Exception {
        byte type;
        do {
            int i;
            if ((i = this.in.read()) == -1) {
                return false;
            }
            type = (byte)i;
            if (this.firstBlock && type != 1) {
                throw new IOException("Invalid spectrum data file.");
            }
            this.firstBlock = false;
        } while (this.readBlock(type));
        this.in.close();
        return true;
    }

    private boolean readBlock(byte blocktype) throws Exception {
        switch (blocktype) {
            case 1: {
                this.readHeader();
                return true;
            }
            case 16: {
                this.spectrum.addTransaction(this.transactionDeserialize.deserialize());
                return true;
            }
        }
        throw new IOException(String.format("Unknown block type %x.", blocktype));
    }

    private void readHeader() throws IOException {
        if (this.in.readChar() != '\uc0c0') {
            throw new IOException("Invalid execution data file.");
        }
        char version = this.in.readChar();
        if (version != SerialisationIdentifiers.FORMAT_VERSION) {
            throw new IncompatibleSpectrumVersionException(version);
        }
    }

    public class IncompatibleSpectrumVersionException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private final int actualVersion;

        public IncompatibleSpectrumVersionException(int actualVersion) {
            super(String.format("Cannot read spectrum data version 0x%x. This version of GZoltar uses spectrum data version 0x%x.", actualVersion, (int)SerialisationIdentifiers.FORMAT_VERSION));
            this.actualVersion = actualVersion;
        }

        public int getExpectedVersion() {
            return SerialisationIdentifiers.FORMAT_VERSION;
        }

        public int getActualVersion() {
            return this.actualVersion;
        }
    }

    private final class TransactionDeserialize {
        private TransactionDeserialize() {
        }

        public Transaction deserialize() throws IOException, CloneNotSupportedException {
            String transactionName = SpectrumReader.this.in.readUTF();
            LinkedHashMap<String, Pair<String, boolean[]>> activity = new LinkedHashMap<String, Pair<String, boolean[]>>();
            for (int numberActivities = SpectrumReader.this.in.readVarInt(); numberActivities > 0; --numberActivities) {
                String probeGroupHash = SpectrumReader.this.in.readUTF();
                String probeGroupName = SpectrumReader.this.in.readUTF();
                boolean[] hitArray = SpectrumReader.this.in.readBooleanArray();
                if (SpectrumReader.this.spectrum.getProbeGroupByHash(probeGroupHash) == null) {
                    try {
                        CtClass ctClass = ClassPool.getDefault().get(probeGroupName);
                        SpectrumReader.this.instrumenter.instrument(ctClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (SpectrumReader.this.spectrum.getProbeGroupByHash(probeGroupHash) == null) {
                        throw new RuntimeException("ProbeGroup '" + probeGroupHash + "' | '" + probeGroupName + "' has not been added to the spectrum instance!");
                    }
                }
                activity.put(probeGroupHash, new ImmutablePair<String, boolean[]>(probeGroupName, hitArray));
            }
            TransactionOutcome transactionOutcome = TransactionOutcome.valueOf(SpectrumReader.this.in.readUTF());
            long runtime = SpectrumReader.this.in.readLong();
            String stackTrace = SpectrumReader.this.in.readUTF();
            return new Transaction(transactionName, activity, transactionOutcome, runtime, stackTrace);
        }
    }
}

