/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.core.spectrum;

import com.gzoltar.internal.core.model.Transaction;
import com.gzoltar.internal.core.spectrum.ISpectrum;
import com.gzoltar.internal.core.util.SerialisationIdentifiers;
import com.gzoltar.internal.org.apache.commons.lang3.tuple.Pair;
import com.gzoltar.internal.org.jacoco.core.internal.data.CompactDataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class SpectrumWriter {
    private final CompactDataOutput out;

    public SpectrumWriter(OutputStream output) throws IOException {
        this.out = new CompactDataOutput(output);
        this.writeHeader();
    }

    private void writeHeader() throws IOException {
        this.out.writeByte(1);
        this.out.writeChar(49344);
        this.out.writeChar(SerialisationIdentifiers.FORMAT_VERSION);
    }

    public void writeSpectrum(ISpectrum spectrum) throws IOException {
        for (Transaction transaction : spectrum.getTransactions()) {
            TransactionSerialize.serialize(this.out, transaction);
        }
        this.out.close();
    }

    private static final class TransactionSerialize {
        private TransactionSerialize() {
        }

        public static void serialize(CompactDataOutput out, Transaction transaction) throws IOException {
            if (transaction.hasActivations()) {
                out.writeByte(16);
                out.writeUTF(transaction.getName());
                Map<String, Pair<String, boolean[]>> activity = transaction.getActivity();
                out.writeVarInt(activity.size());
                for (Map.Entry<String, Pair<String, boolean[]>> entry : activity.entrySet()) {
                    out.writeUTF(entry.getKey());
                    out.writeUTF(entry.getValue().getLeft());
                    out.writeBooleanArray(entry.getValue().getRight());
                }
                out.writeUTF(transaction.getTransactionOutcome().name());
                out.writeLong(transaction.getRuntime());
                out.writeUTF(transaction.getStackTrace());
            }
        }
    }
}

