/*
 * Decompiled with CFR 0.152.
 */
package com.gzoltar.internal.org.jacoco.core.internal.instr;

import com.gzoltar.internal.org.jacoco.core.internal.BytecodeVersion;
import com.gzoltar.internal.org.jacoco.core.internal.flow.ClassProbesAdapter;
import com.gzoltar.internal.org.jacoco.core.internal.instr.ClassFieldProbeArrayStrategy;
import com.gzoltar.internal.org.jacoco.core.internal.instr.IProbeArrayStrategy;
import com.gzoltar.internal.org.jacoco.core.internal.instr.InterfaceFieldProbeArrayStrategy;
import com.gzoltar.internal.org.jacoco.core.internal.instr.LocalProbeArrayStrategy;
import com.gzoltar.internal.org.jacoco.core.internal.instr.NoneProbeArrayStrategy;
import com.gzoltar.internal.org.jacoco.core.internal.instr.ProbeCounter;
import com.gzoltar.internal.org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import com.gzoltar.internal.org.objectweb.asm.ClassReader;

public final class ProbeArrayStrategyFactory {
    private ProbeArrayStrategyFactory() {
    }

    public static IProbeArrayStrategy createFor(long classId, ClassReader reader, IExecutionDataAccessorGenerator accessorGenerator) {
        boolean withFrames;
        String className = reader.getClassName();
        int version = BytecodeVersion.get(reader.b);
        boolean bl = withFrames = version >= 50;
        if (ProbeArrayStrategyFactory.isInterfaceOrModule(reader)) {
            ProbeCounter counter = ProbeArrayStrategyFactory.getProbeCounter(reader);
            if (counter.getCount() == 0) {
                return new NoneProbeArrayStrategy();
            }
            if (version >= 52 && counter.hasMethods()) {
                return new InterfaceFieldProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
            }
            return new LocalProbeArrayStrategy(className, classId, counter.getCount(), accessorGenerator);
        }
        return new ClassFieldProbeArrayStrategy(className, classId, withFrames, accessorGenerator);
    }

    private static boolean isInterfaceOrModule(ClassReader reader) {
        return (reader.getAccess() & 0x8200) != 0;
    }

    private static ProbeCounter getProbeCounter(ClassReader reader) {
        ProbeCounter counter = new ProbeCounter();
        reader.accept(new ClassProbesAdapter(counter, false), 0);
        return counter;
    }
}

