/*
 * Decompiled with CFR 0.152.
 */
package com.heershingenmosiken.assertions;

import com.heershingenmosiken.assertions.AssertionData;
import com.heershingenmosiken.assertions.AssertionHandler;
import com.heershingenmosiken.assertions.ThrowableFactory;
import com.heershingenmosiken.assertions.Utils;
import java.util.Collection;
import java.util.PriorityQueue;

public class Assertions {
    private static final int DEFAULT_PRIORITY = 0;
    private static final PriorityQueue<PriorityHandler> handlers = new PriorityQueue(5, (l, r) -> ((PriorityHandler)r).priority - ((PriorityHandler)l).priority);

    public static void addAssertionHandler(AssertionHandler assertionHandler) {
        handlers.add(new PriorityHandler(assertionHandler, 0));
    }

    public static void addAssertionHandler(AssertionHandler assertionHandler, int priority) {
        handlers.add(new PriorityHandler(assertionHandler, priority));
    }

    public static void removeAssertionHandler(AssertionHandler assertionHandler) {
        Utils.filter(handlers, priorityHandler -> ((PriorityHandler)priorityHandler).handler == assertionHandler);
    }

    private static boolean hasHandlers() {
        return !handlers.isEmpty();
    }

    protected static void internalRaiseAssertion(ThrowableFactory throwableFactory, String message, boolean silent) {
        if (Assertions.hasHandlers()) {
            AssertionData assertionData = new AssertionData(throwableFactory.create(), message, silent);
            Utils.forEach(handlers, priorityHandler -> ((PriorityHandler)priorityHandler).handler.handle(assertionData));
        }
    }

    public static void log(String message) {
        Utils.forEach(handlers, priorityHandler -> ((PriorityHandler)priorityHandler).handler.log(message));
    }

    public static void fail(Throwable throwable) {
        Assertions.internalRaiseAssertion(() -> throwable, "Fail", false);
    }

    public static void failSilently(Throwable throwable) {
        Assertions.internalRaiseAssertion(() -> throwable, "FailSilently", true);
    }

    public static void fail(ThrowableFactory throwableFactory) {
        Assertions.internalRaiseAssertion(throwableFactory, "Fail", false);
    }

    public static void assertTrue(boolean shouldBeTrue, ThrowableFactory throwableFactory) {
        if (!shouldBeTrue) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertTrue", false);
        }
    }

    public static void assertFalse(boolean shouldBeFalse, ThrowableFactory throwableFactory) {
        if (shouldBeFalse) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertFalse", false);
        }
    }

    public static void assertNull(Object shouldBeNull, ThrowableFactory throwableFactory) {
        if (shouldBeNull != null) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertNull but was [" + shouldBeNull + "]", false);
        }
    }

    public static void assertNotNull(Object shouldNotBeNull, ThrowableFactory throwableFactory) {
        if (shouldNotBeNull == null) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertNotNull", false);
        }
    }

    public static void assertEmpty(Collection shouldBeEmpty, ThrowableFactory throwableFactory) {
        if (!shouldBeEmpty.isEmpty()) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertEmpty but size = " + shouldBeEmpty.size(), false);
        }
    }

    public static void assertNotEmpty(Collection shouldNotBeEmpty, ThrowableFactory throwableFactory) {
        if (shouldNotBeEmpty.isEmpty()) {
            Assertions.internalRaiseAssertion(throwableFactory, "AssertNotEmpty but size = " + shouldNotBeEmpty.size(), false);
        }
    }

    private static void tearDown() {
        handlers.clear();
    }

    private static class PriorityHandler {
        private final AssertionHandler handler;
        private final int priority;

        private PriorityHandler(AssertionHandler handler, int priority) {
            this.handler = handler;
            this.priority = priority;
        }
    }
}

