/*
 * Decompiled with CFR 0.152.
 */
package com.heershingenmosiken.assertions;

import java.util.ArrayList;
import java.util.Collection;

public final class Utils {
    public static <T> void forEach(Collection<T> collection, Consumer<T> consumer) {
        for (T item : collection) {
            consumer.accept(item);
        }
    }

    public static <T> void filter(Collection<T> queue, Predicate<T> filter) {
        ArrayList<T> itemsToRemove = new ArrayList<T>();
        for (T item : queue) {
            if (!filter.test(item)) continue;
            itemsToRemove.add(item);
        }
        queue.removeAll(itemsToRemove);
    }

    static interface Consumer<T> {
        public void accept(T var1);
    }

    static interface Predicate<T> {
        public boolean test(T var1);
    }
}

