/*
 * Copyright (C) 2020-2025 Philip Helger (www.helger.com)
 * philip[at]helger[dot]com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.helger.font.noto_sans_hk;

import com.helger.annotation.Nonempty;
import com.helger.font.api.EFontStyle;
import com.helger.font.api.EFontType;
import com.helger.font.api.EFontWeight;
import com.helger.font.api.FontResource;
import com.helger.font.api.IFontResource;
import com.helger.font.api.IFontStyle;
import com.helger.font.api.IFontWeight;
import com.helger.font.api.IHasFontResource;

import jakarta.annotation.Nonnull;

/**
 * Defines the available font resources available in this library.
 *
 * @author Philip Helger
 */
public enum EFontResourceNotoSansHK implements IHasFontResource
{
  // Noto Sans HK (Open Font License)
  NOTO_SANS_HK_THIN ("Noto Sans HK", EFontType.TTF, EFontStyle.REGULAR, EFontWeight.THIN, "fonts/ttf/NotoSansHK/NotoSansHK-Thin.ttf"),
  NOTO_SANS_HK_LIGHT ("Noto Sans HK", EFontType.TTF, EFontStyle.REGULAR, EFontWeight.LIGHT, "fonts/ttf/NotoSansHK/NotoSansHK-Light.ttf"),
  NOTO_SANS_HK_REGULAR ("Noto Sans HK",
                        EFontType.TTF,
                        EFontStyle.REGULAR,
                        EFontWeight.REGULAR,
                        "fonts/ttf/NotoSansHK/NotoSansHK-Regular.ttf"),
  NOTO_SANS_HK_MEDIUM ("Noto Sans HK", EFontType.TTF, EFontStyle.REGULAR, EFontWeight.MEDIUM, "fonts/ttf/NotoSansHK/NotoSansHK-Medium.ttf"),
  NOTO_SANS_HK_BOLD ("Noto Sans HK", EFontType.TTF, EFontStyle.REGULAR, EFontWeight.BOLD, "fonts/ttf/NotoSansHK/NotoSansHK-Bold.ttf"),
  NOTO_SANS_HK_BLACK ("Noto Sans HK", EFontType.TTF, EFontStyle.REGULAR, EFontWeight.BLACK, "fonts/ttf/NotoSansHK/NotoSansHK-Black.ttf");

  private final FontResource m_aRes;

  EFontResourceNotoSansHK (@Nonnull @Nonempty final String sFontName,
                           @Nonnull final EFontType eFontType,
                           @Nonnull final IFontStyle aFontStyle,
                           @Nonnull final IFontWeight aFontWeight,
                           @Nonnull @Nonempty final String sPath)
  {
    m_aRes = new FontResource (sFontName, eFontType, aFontStyle, aFontWeight, sPath);
  }

  @Nonnull
  public IFontResource getFontResource ()
  {
    return m_aRes;
  }
}
