/*
 * Decompiled with CFR 0.152.
 */
package com.helger.font.test;

import com.helger.annotation.concurrent.Immutable;
import com.helger.font.api.IFontResource;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FontTester {
    private static final Logger LOGGER = LoggerFactory.getLogger(FontTester.class);

    private FontTester() {
    }

    public static void testFontResourcePDFBoxCompatibility(@Nonnull IFontResource iFontResource) {
        Assert.assertNotNull((Object)iFontResource);
        TrueTypeFont trueTypeFont = null;
        try {
            switch (iFontResource.getFontType()) {
                case TTF: {
                    LOGGER.info("Reading TTF " + iFontResource.getFontName());
                    trueTypeFont = new TTFParser().parse((RandomAccessRead)new RandomAccessReadBuffer(iFontResource.getInputStream()));
                    break;
                }
                case OTF: {
                    LOGGER.info("Reading OTF " + iFontResource.getFontName());
                    trueTypeFont = new OTFParser().parse((RandomAccessRead)new RandomAccessReadBuffer(iFontResource.getInputStream()));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot parse font resources of type " + String.valueOf(iFontResource.getFontType()));
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertNotNull((String)("Cannot parse " + String.valueOf(iFontResource)), trueTypeFont);
    }
}

