/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.accarea;

import com.helger.commons.name.IHasDisplayName;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.currency.ECurrency;
import com.helger.tenancy.tenant.ITenantObject;
import com.helger.tenancy.uitext.IHasUIText;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAccountingArea
extends ITenantObject,
IHasDisplayName,
IHasUIText {
    @Nullable
    public String getCompanyType();

    default public boolean hasCompanyType() {
        return StringHelper.hasText((String)this.getCompanyType());
    }

    @Nonnull
    default public String getDisplayNameAndCompanyType() {
        return this.getDisplayNameAndCompanyType(" ");
    }

    @Nonnull
    default public String getDisplayNameAndCompanyType(@Nonnull String string) {
        return StringHelper.getImplodedNonEmpty((String)string, (String[])new String[]{this.getDisplayName(), this.getCompanyType()});
    }

    @Nullable
    public String getCompanyVATIN();

    default public boolean hasCompanyVATIN() {
        return StringHelper.hasText((String)this.getCompanyVATIN());
    }

    @Nullable
    public String getCompanyNumber();

    default public boolean hasCompanyNumber() {
        return StringHelper.hasText((String)this.getCompanyNumber());
    }

    @Nullable
    public String getCustomerNumber();

    default public boolean hasCustomerNumber() {
        return StringHelper.hasText((String)this.getCustomerNumber());
    }

    @Nonnull
    public IPostalAddress getAddress();

    @Nullable
    public String getTelephone();

    default public boolean hasTelephone() {
        return StringHelper.hasText((String)this.getTelephone());
    }

    @Nullable
    public String getFax();

    default public boolean hasFax() {
        return StringHelper.hasText((String)this.getFax());
    }

    @Nullable
    public String getEmailAddress();

    default public boolean hasEmailAddress() {
        return StringHelper.hasText((String)this.getEmailAddress());
    }

    @Nullable
    public String getWebSite();

    default public boolean hasWebSite() {
        return StringHelper.hasText((String)this.getWebSite());
    }

    @Nullable
    public ECurrency getDefaultCurrency();

    @Nullable
    default public String getDefaultCurrencyID() {
        ECurrency eCurrency = this.getDefaultCurrency();
        return eCurrency == null ? null : eCurrency.getID();
    }

    default public boolean hasDefaultCurrency() {
        return this.getDefaultCurrency() != null;
    }

    @Nullable
    public String getOfficeLocation();

    default public boolean hasOfficeLocation() {
        return StringHelper.hasText((String)this.getOfficeLocation());
    }

    @Nullable
    public String getCommercialRegistrationNumber();

    default public boolean hasCommercialRegistrationNumber() {
        return StringHelper.hasText((String)this.getCommercialRegistrationNumber());
    }

    @Nullable
    public String getCommercialCourt();

    default public boolean hasCommercialCourt() {
        return StringHelper.hasText((String)this.getCommercialCourt());
    }
}

