/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.xhe;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.log.ConditionalLogger;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.xhe.DBNAlliancePayload;
import com.helger.peppol.xhe.write.DBNAllianceXHEDocumentWriter;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.xhe.v10.XHE10XHEType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class DBNAllianceXHEData {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBNAllianceXHEData.class);
    private final IIdentifierFactory m_aIdentifierFactory;
    private String m_sID;
    private XMLOffsetDateTime m_aCreationDateTime;
    private String m_sFromPartyScheme;
    private String m_sFromPartyValue;
    private String m_sToPartyScheme;
    private String m_sToPartyValue;
    private ICommonsList<DBNAlliancePayload> m_aPayloads = new CommonsArrayList();

    public DBNAllianceXHEData(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @Nullable
    public String getID() {
        return this.m_sID;
    }

    public boolean hasID() {
        return StringHelper.hasText((String)this.m_sID);
    }

    @Nonnull
    public DBNAllianceXHEData setID(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_sID = string;
        return this;
    }

    @Nullable
    public XMLOffsetDateTime getCreationDateTime() {
        return this.m_aCreationDateTime;
    }

    public boolean hasCreationDateTime() {
        return this.m_aCreationDateTime != null;
    }

    @Nonnull
    public DBNAllianceXHEData setCreationDateAndTime(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        ValueEnforcer.notNull((Object)xMLOffsetDateTime, (String)"CreationDateTime");
        this.m_aCreationDateTime = PDTFactory.getWithMillisOnly((XMLOffsetDateTime)xMLOffsetDateTime);
        return this;
    }

    @Nonnull
    public DBNAllianceXHEData setCreationDateAndTimeNow() {
        return this.setCreationDateAndTime(PDTFactory.getCurrentXMLOffsetDateTime());
    }

    @Nullable
    public String getFromPartyScheme() {
        return this.m_sFromPartyScheme;
    }

    @Nullable
    public String getFromPartyValue() {
        return this.m_sFromPartyValue;
    }

    @Nullable
    public IParticipantIdentifier getFromPartyAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sFromPartyScheme, this.m_sFromPartyValue);
    }

    @Nonnull
    public DBNAllianceXHEData setFromParty(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sFromPartyScheme = string;
        this.m_sFromPartyValue = string2;
        return this;
    }

    @Nonnull
    public DBNAllianceXHEData setFromParty(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"FromPartyID");
        return this.setFromParty(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @Nullable
    public String getToPartyScheme() {
        return this.m_sToPartyScheme;
    }

    @Nullable
    public String getToPartyValue() {
        return this.m_sToPartyValue;
    }

    @Nullable
    public IParticipantIdentifier getToPartyAsIdentifier() {
        return this.m_aIdentifierFactory.createParticipantIdentifier(this.m_sToPartyScheme, this.m_sToPartyValue);
    }

    @Nonnull
    public DBNAllianceXHEData setToParty(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Value");
        this.m_sToPartyScheme = string;
        this.m_sToPartyValue = string2;
        return this;
    }

    @Nonnull
    public DBNAllianceXHEData setToParty(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ToPartyID");
        return this.setToParty(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @Nullable
    public List<DBNAlliancePayload> getPayloads() {
        return this.m_aPayloads;
    }

    @Nonnull
    public DBNAllianceXHEData setPayloads(@Nonnull ICommonsList<DBNAlliancePayload> iCommonsList) {
        ValueEnforcer.notNull(iCommonsList, (String)"Payloads");
        this.m_aPayloads = iCommonsList;
        return this;
    }

    @Nonnull
    public DBNAllianceXHEData addPayload(@Nonnull DBNAlliancePayload dBNAlliancePayload) {
        ValueEnforcer.notNull((Object)dBNAlliancePayload, (String)"Payload");
        this.m_aPayloads.add((Object)dBNAlliancePayload);
        return this;
    }

    public boolean areAllFieldsSet(boolean bl) {
        ConditionalLogger conditionalLogger = new ConditionalLogger(LOGGER, bl);
        if (StringHelper.hasNoText((String)this.m_sID)) {
            conditionalLogger.info("DBNAlliance XHE data - ID Value is missing");
            return false;
        }
        if (this.m_aCreationDateTime == null) {
            conditionalLogger.info("DBNAlliance XHE data - Creation Date Time Value is missing");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sFromPartyScheme)) {
            conditionalLogger.info("DBNAlliance XHE data - From Party Scheme is missing");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sFromPartyValue)) {
            conditionalLogger.info("DBNAlliance XHE data - From Party Value is missing");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sToPartyScheme)) {
            conditionalLogger.info("DBNAlliance XHE data - To Party Scheme is missing");
            return false;
        }
        if (StringHelper.hasNoText((String)this.m_sToPartyValue)) {
            conditionalLogger.info("DBNAlliance XHE data - To Party Value is missing");
            return false;
        }
        if (this.m_aPayloads.isEmpty()) {
            conditionalLogger.info("DBNAlliance XHE data - An envelope MUST contain at least one payload.");
            return false;
        }
        return true;
    }

    public boolean areAllFieldsSet() {
        return this.areAllFieldsSet(false);
    }

    @Nonnull
    public XHE10XHEType getAsXHEDocument() {
        return DBNAllianceXHEDocumentWriter.createExchangeHeaderEnvelope(this);
    }
}

