/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.xhe.read;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.text.util.TextHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EDBNAllianceXHEDocumentReadError implements IHasID<String>
{
    INVALID_XHE_XML("invalid-xhe-xml", "Failed to interpret ExchangeHeaderEnvelope as XML."),
    MISSING_PAYLOADS_PAYLOAD("missing-payloads-payload", "The ''Payloads'' element is not present."),
    INVALID_XHE_VERSION_ID("invalid-xhe-version-id", "The ''VersionID'' element has the illegal value ''{0}''."),
    CUSTOMIZATION_ID_MISSING("customization-id-missing", "The ''XHE/CustomizationID'' element is missing."),
    INVALID_CUSTOMIZATION_ID_SCHEMA_ID("invalid-customization-id-schema-id", "The ''XHE/CustomizationID/schemaID'' attribute has the invalid value ''{0}''."),
    INVALID_CUSTOMIZATION_ID_VALUE("invalid-customization-id-value", "The ''XHE/CustomizationID'' has the invalid value ''{0}''."),
    PROFILE_ID_MISSING("profile-id-missing", "The ''XHE/ProfileID'' element is missing."),
    INVALID_PROFILE_ID_SCHEMA_ID("invalid-profile-id-schema-id", "The ''XHE/ProfileID/schemaID'' attribute has the invalid value ''{0}''."),
    INVALID_PROFILE_ID_VALUE("invalid-profile-id-value", "The ''XHE/ProfileID'' has the invalid value ''{0}''."),
    HEADER_MISSING("xhe-header-missing", "The ''XHE/Header'' element is missing."),
    INVALID_HEADER_ID("invalid-header-id-value", "The ''XHE/Header/ID'' has the invalid value ''{0}''."),
    INVALID_CREATION_DATE_TIME("invalid-creation-date-time", "The ''XHE/Header/CreationDateAndTime'' element has the invalid value ''{0}'' according to the defined rules."),
    INVALID_FROM_PARTY_COUNT("invalid-from-party-count", "Not exactly one ''FromParty'' element is present but {0}."),
    INVALID_FROM_PARTY_SCHEMA_ID("invalid-from-party-schema-id", "The ''XHE/Header/FromParty/PartyIdentification/ID/schemaID'' attribute has the invalid value ''{0}''."),
    INVALID_FROM_PARTY_VALUE("invalid-from-party-value", "The ''XHE/Header/FromParty/PartyIdentification/ID'' has the invalid value ''{0}''."),
    INVALID_TO_PARTY_COUNT("invalid-to-party-count", "Not exactly one ''ToParty'' element is present but {0}."),
    INVALID_TO_PARTY_IDENTIFICATION_COUNT("invalid-to-party-identification-count", "Not exactly one ''ToParty/PartyIdentification'' element is present but {0}."),
    INVALID_TO_PARTY_SCHEMA_ID("invalid-to-party-schema-id", "The ''XHE/Header/ToParty/PartyIdentification/ID/schemaID'' attribute has the invalid value ''{0}''."),
    INVALID_TO_PARTY_VALUE("invalid-from-party-value", "The ''XHE/Header/ToParty/PartyIdentification/ID'' has the invalid value ''{0}''."),
    INVALID_PAYLOAD_ID_VALUE("invalid-payload-id-value", "The ''XHE/Payloads/Payload/ID'' has the invalid value ''{0}''."),
    INVALID_CONTENT_TYPE_CODE_LIST_ID("invalid-content-type-code-list-id", "The ''XHE/Payloads/Payload/ContentTypeCode/listID'' has the invalid value ''{0}''."),
    INVALID_CONTENT_TYPE_CODE_VALUE("invalid-content-type-code-value", "The ''XHE/Payloads/Payload/ContentTypeCode'' has the invalid value ''{0}''."),
    INVALID_INSTANCE_ENCRYPTION_INDICATOR_VALUE("invalid-instance-encryption-indicator-value", "The ''XHE/Payloads/Payload/InstanceEncryptionIndicator'' has the invalid value ''{0}''."),
    INSTANCE_ENCRYPTION_INDICATOR_MISSING("instance-encryption-indicator-missing", "The ''XHE/Payloads/Payload/InstanceEncryptionIndicator'' element is missing."),
    INVALID_BUSINESS_MESSAGE("invalid-business-message", "The main business message is invalid according to the defined rules."),
    GENERIC_XHE_ERROR("generic-xhe-error", "A generic error occurred.");

    private final String m_sID;
    private final String m_sErrorMsg;

    private EDBNAllianceXHEDocumentReadError(String string2, String string3) {
        this.m_sID = string2;
        this.m_sErrorMsg = string3;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage() {
        return this.m_sErrorMsg;
    }

    @Nonnull
    @Nonempty
    public String getErrorMessage(Object ... objectArray) {
        return TextHelper.getFormattedText((String)this.m_sErrorMsg, (Object[])objectArray);
    }

    @Nullable
    public static EDBNAllianceXHEDocumentReadError getFromIDOrNull(@Nullable String string) {
        return (EDBNAllianceXHEDocumentReadError)EnumHelper.getFromIDOrNull(EDBNAllianceXHEDocumentReadError.class, (Object)string);
    }

    @Nullable
    public static EDBNAllianceXHEDocumentReadError getFromIDOrDefault(@Nullable String string, @Nullable EDBNAllianceXHEDocumentReadError eDBNAllianceXHEDocumentReadError) {
        return (EDBNAllianceXHEDocumentReadError)EnumHelper.getFromIDOrDefault(EDBNAllianceXHEDocumentReadError.class, (Object)string, (Enum)eDBNAllianceXHEDocumentReadError);
    }
}

