/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.xhe;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.w3c.dom.Element;

@NotThreadSafe
public class DBNAlliancePayload {
    public static final String DEFAULT_CONTENT_TYPE_CODE_LIST_ID = "MIME";
    public static final boolean DEFAULT_INSTANCE_ENCRYPTION_INDICATOR = false;
    private final IIdentifierFactory m_aIdentifierFactory;
    private String m_sDescription;
    private String m_sContentTypeCodeListID;
    private String m_sContentTypeCode;
    private String m_sCustomizationIDSchemeID;
    private String m_sCustomizationID;
    private String m_sProfileIDSchemeID;
    private String m_sProfileID;
    private boolean m_bInstanceEncryptionIndicator = false;
    private String m_sInstanceEncryptionMethod;
    private Element m_aPayloadContent;

    public DBNAlliancePayload(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    public boolean hasDescription() {
        return StringHelper.hasText((String)this.m_sDescription);
    }

    @Nonnull
    public DBNAlliancePayload setDescription(@Nullable String string) {
        this.m_sDescription = string;
        return this;
    }

    @Nullable
    public String getContentTypeCodeListID() {
        return this.m_sContentTypeCodeListID;
    }

    public boolean hasContentTypeCodeListID() {
        return StringHelper.hasText((String)this.m_sContentTypeCodeListID);
    }

    @Nonnull
    public DBNAlliancePayload setContentTypeCodeListID(@Nullable String string) {
        this.m_sContentTypeCodeListID = string;
        return this;
    }

    @Nullable
    public String getContentTypeCode() {
        return this.m_sContentTypeCode;
    }

    public boolean hasContentTypeCode() {
        return StringHelper.hasText((String)this.m_sContentTypeCode);
    }

    @Nonnull
    public DBNAlliancePayload setContentTypeCode(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Value");
        this.m_sContentTypeCode = string;
        return this;
    }

    @Nonnull
    public DBNAlliancePayload setContentTypeCode(@Nullable String string, @Nonnull @Nonempty String string2) {
        return this.setContentTypeCodeListID(string).setContentTypeCode(string2);
    }

    @Nonnull
    public DBNAlliancePayload setContentTypeCode(@Nonnull IMimeType iMimeType) {
        ValueEnforcer.notNull((Object)iMimeType, (String)"Value");
        return this.setContentTypeCode(iMimeType.getAsString());
    }

    @Nonnull
    public DBNAlliancePayload setContentTypeCodeXML() {
        return this.setContentTypeCode(CMimeType.APPLICATION_XML);
    }

    @Nullable
    public String getCustomizationIDSchemeID() {
        return this.m_sCustomizationIDSchemeID;
    }

    public boolean hasCustomizationIDSchemeID() {
        return StringHelper.hasText((String)this.m_sCustomizationIDSchemeID);
    }

    @Nonnull
    public DBNAlliancePayload setCustomizationIDSchemeID(@Nullable String string) {
        this.m_sCustomizationIDSchemeID = string;
        return this;
    }

    @Nullable
    public String getCustomizationID() {
        return this.m_sCustomizationID;
    }

    public boolean hasCustomizationID() {
        return StringHelper.hasText((String)this.m_sCustomizationID);
    }

    @Nonnull
    public DBNAlliancePayload setCustomizationID(@Nullable String string) {
        this.m_sCustomizationID = string;
        return this;
    }

    @Nullable
    public IDocumentTypeIdentifier getCustomizationIDAsIdentifier() {
        return this.m_aIdentifierFactory.createDocumentTypeIdentifier(this.m_sCustomizationIDSchemeID, this.m_sCustomizationID);
    }

    @Nonnull
    public DBNAlliancePayload setCustomizationID(@Nullable IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        if (iDocumentTypeIdentifier != null) {
            return this.setCustomizationIDSchemeID(iDocumentTypeIdentifier.getScheme()).setCustomizationID(iDocumentTypeIdentifier.getValue());
        }
        return this;
    }

    @Nonnull
    public DBNAlliancePayload setCustomizationID(@Nullable String string, @Nullable String string2) {
        return this.setCustomizationIDSchemeID(string).setCustomizationID(string2);
    }

    @Nullable
    public String getProfileIDSchemeID() {
        return this.m_sProfileIDSchemeID;
    }

    public boolean hasProfileIDSchemeID() {
        return StringHelper.hasText((String)this.m_sProfileIDSchemeID);
    }

    @Nonnull
    public DBNAlliancePayload setProfileIDSchemeID(@Nullable String string) {
        this.m_sProfileIDSchemeID = string;
        return this;
    }

    @Nullable
    public String getProfileID() {
        return this.m_sProfileID;
    }

    public boolean hasProfileID() {
        return StringHelper.hasText((String)this.m_sProfileID);
    }

    @Nonnull
    public DBNAlliancePayload setProfileID(@Nullable String string) {
        this.m_sProfileID = string;
        return this;
    }

    @Nullable
    public IProcessIdentifier getProfileIDAsIdentifier() {
        return this.m_aIdentifierFactory.createProcessIdentifier(this.m_sProfileIDSchemeID, this.m_sProfileID);
    }

    @Nonnull
    public DBNAlliancePayload setProfileID(@Nullable IProcessIdentifier iProcessIdentifier) {
        if (iProcessIdentifier != null) {
            return this.setProfileIDSchemeID(iProcessIdentifier.getScheme()).setProfileID(iProcessIdentifier.getValue());
        }
        return this;
    }

    @Nonnull
    public DBNAlliancePayload setProfileID(@Nullable String string, @Nullable String string2) {
        return this.setProfileIDSchemeID(string).setProfileID(string2);
    }

    public boolean isInstanceEncryptionIndicator() {
        return this.m_bInstanceEncryptionIndicator;
    }

    @Nonnull
    public DBNAlliancePayload setInstanceEncryptionIndicator(boolean bl) {
        this.m_bInstanceEncryptionIndicator = bl;
        return this;
    }

    @Nullable
    public String getInstanceEncryptionMethod() {
        return this.m_sInstanceEncryptionMethod;
    }

    public boolean hasInstanceEncryptionMethod() {
        return StringHelper.hasText((String)this.m_sInstanceEncryptionMethod);
    }

    @Nonnull
    public DBNAlliancePayload setInstanceEncryptionMethod(@Nullable String string) {
        this.m_sInstanceEncryptionMethod = string;
        return this;
    }

    @Nullable
    @ReturnsMutableCopy
    public Element getPayloadContent() {
        return this.m_aPayloadContent == null ? null : (Element)this.m_aPayloadContent.cloneNode(true);
    }

    @Nullable
    @ReturnsMutableObject
    public Element getPayloadContentNoClone() {
        return this.m_aPayloadContent;
    }

    public boolean hasPayloadContent() {
        return this.m_aPayloadContent != null;
    }

    @Nonnull
    public DBNAlliancePayload setPayloadContent(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"PayloadContent");
        this.m_aPayloadContent = (Element)element.cloneNode(true);
        return this;
    }

    @Nonnull
    public DBNAlliancePayload setPayloadContentNoClone(@Nonnull Element element) {
        ValueEnforcer.notNull((Object)element, (String)"PayloadContent");
        this.m_aPayloadContent = element;
        return this;
    }

    public boolean areAllMandatoryFieldsSet() {
        return this.hasContentTypeCode() && this.hasPayloadContent();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Description", (Object)this.m_sDescription).append("ContentTypeCodeListID", (Object)this.m_sContentTypeCodeListID).append("ContentTypeCode", (Object)this.m_sContentTypeCode).append("CustomizationIDSchemeID", (Object)this.m_sCustomizationIDSchemeID).append("CustomizationID", (Object)this.m_sCustomizationID).append("ProfileIDSchemeID", (Object)this.m_sProfileIDSchemeID).append("ProfileID", (Object)this.m_sProfileID).append("InstanceEncryptionIndicator", this.m_bInstanceEncryptionIndicator).append("InstanceEncryptionMethod", (Object)this.m_sInstanceEncryptionMethod).append("PayloadContent", (Object)this.m_aPayloadContent).getToString();
    }
}

