/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.xhe.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.error.IError;
import com.helger.commons.error.SingleError;
import com.helger.commons.error.level.IHasErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.xhe.DBNAlliancePayload;
import com.helger.peppol.xhe.DBNAllianceXHEData;
import com.helger.peppol.xhe.read.DBNAllianceXHEDataReadException;
import com.helger.peppol.xhe.read.EDBNAllianceXHEDataReadError;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.xhe.v10.XHE10Marshaller;
import com.helger.xhe.v10.XHE10XHEType;
import com.helger.xhe.v10.cac.XHE10PartyType;
import com.helger.xhe.v10.cac.XHE10PayloadContentType;
import com.helger.xhe.v10.cac.XHE10PayloadType;
import com.helger.xhe.v10.cac.XHE10PayloadsType;
import com.helger.xhe.v10.cbc.XHE10ContentTypeCodeType;
import com.helger.xhe.v10.cbc.XHE10CustomizationIDType;
import com.helger.xhe.v10.cbc.XHE10InstanceEncryptionIndicatorType;
import com.helger.xhe.v10.cbc.XHE10InstanceEncryptionMethodType;
import com.helger.xhe.v10.cbc.XHE10ProfileIDType;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DBNAllianceXHEDataReader {
    public static final boolean DEFAULT_PERFORM_VALUE_CHECKS = true;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBNAllianceXHEDataReader.class);
    private final IIdentifierFactory m_aIdentifierFactory;
    private boolean m_bPerformValueChecks = true;

    public DBNAllianceXHEDataReader(@Nonnull IIdentifierFactory iIdentifierFactory) {
        ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
        this.m_aIdentifierFactory = iIdentifierFactory;
    }

    @Nonnull
    public final IIdentifierFactory getIdentifierFactory() {
        return this.m_aIdentifierFactory;
    }

    public final boolean isPerformValueChecks() {
        return this.m_bPerformValueChecks;
    }

    @Nonnull
    public final DBNAllianceXHEDataReader setPerformValueChecks(boolean bl) {
        this.m_bPerformValueChecks = bl;
        return this;
    }

    @OverrideOnDemand
    protected boolean isValidXHEVersionID(@Nullable String string) {
        return "1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidCustomizationIDSchemaID(@Nullable String string) {
        return "bdx-docid-qns".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidCustomizationID(@Nullable String string) {
        return "http://docs.oasis-open.org/bdxr/ns/XHE/1/ExchangeHeaderEnvelope::XHE##dbnalliance-envelope-1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidProfileID(@Nullable String string) {
        return "dbnalliance-envelope-1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidHeaderID(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidCreationDateTime(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidFromPartySchemaID(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidFromPartyValue(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidToPartySchemaID(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidToPartyValue(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidPayloadIDValue(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidContentTypeCodeListID(@Nullable String string) {
        return "MIME".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidContentTypeCodeValue(@Nullable String string, @Nullable String string2) {
        return "application/xml".equals(string2);
    }

    @OverrideOnDemand
    protected boolean isValidInstanceEncryptionIndicatorValue(@Nullable boolean bl) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isInstanceHashValueExist(@Nullable String string) {
        return string == null;
    }

    @OverrideOnDemand
    protected boolean isValidBusinessMessage(@Nonnull Element element) {
        return true;
    }

    @Nonnull
    @OverrideOnDemand
    protected XHE10Marshaller createXHEMarshaller() {
        XHE10Marshaller xHE10Marshaller = new XHE10Marshaller();
        xHE10Marshaller.setValidationEventHandler(null);
        return xHE10Marshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public DBNAllianceXHEData extractData(@Nonnull @WillClose InputStream inputStream) throws DBNAllianceXHEDataReadException {
        ValueEnforcer.notNull((Object)inputStream, (String)"ExchangeHeaderEnvelope");
        try {
            XHE10XHEType xHE10XHEType = (XHE10XHEType)this.createXHEMarshaller().read(inputStream);
            if (xHE10XHEType == null) {
                throw new DBNAllianceXHEDataReadException(EDBNAllianceXHEDataReadError.INVALID_XHE_XML);
            }
            DBNAllianceXHEData dBNAllianceXHEData = this.extractData(xHE10XHEType);
            return dBNAllianceXHEData;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public DBNAllianceXHEData extractData(@Nonnull IReadableResource iReadableResource) throws DBNAllianceXHEDataReadException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"StandardBusinessDocument");
        XHE10XHEType xHE10XHEType = (XHE10XHEType)this.createXHEMarshaller().read(iReadableResource);
        if (xHE10XHEType == null) {
            throw new DBNAllianceXHEDataReadException(EDBNAllianceXHEDataReadError.INVALID_XHE_XML);
        }
        return this.extractData(xHE10XHEType);
    }

    @Nonnull
    public DBNAllianceXHEData extractData(@Nonnull Node node) throws DBNAllianceXHEDataReadException {
        ValueEnforcer.notNull((Object)node, (String)"ExchangeHeaderEnvelope");
        XHE10XHEType xHE10XHEType = (XHE10XHEType)this.createXHEMarshaller().read(node);
        if (xHE10XHEType == null) {
            throw new DBNAllianceXHEDataReadException(EDBNAllianceXHEDataReadError.INVALID_XHE_XML);
        }
        return this.extractData(xHE10XHEType);
    }

    @Nonnull
    public DBNAllianceXHEData extractData(@Nonnull XHE10XHEType xHE10XHEType) throws DBNAllianceXHEDataReadException {
        ValueEnforcer.notNull((Object)xHE10XHEType, (String)"ExchangeHeaderEnvelope");
        XHE10PayloadsType xHE10PayloadsType = xHE10XHEType.getPayloads();
        if (xHE10PayloadsType == null || xHE10PayloadsType.getPayload().isEmpty()) {
            throw new DBNAllianceXHEDataReadException(EDBNAllianceXHEDataReadError.MISSING_PAYLOADS_PAYLOAD);
        }
        return this.extractData(xHE10XHEType, xHE10PayloadsType);
    }

    @Nonnull
    private static IError _toError(@Nullable String string, @Nonnull EDBNAllianceXHEDataReadError eDBNAllianceXHEDataReadError, Object ... objectArray) {
        return ((SingleError.Builder)((SingleError.Builder)((SingleError.Builder)SingleError.builderError().errorFieldName(string)).errorID(eDBNAllianceXHEDataReadError.getID())).errorText(objectArray == null ? eDBNAllianceXHEDataReadError.getErrorMessage() : eDBNAllianceXHEDataReadError.getErrorMessage(objectArray))).build();
    }

    public void validateData(@Nonnull XHE10XHEType xHE10XHEType, @Nonnull XHE10PayloadsType xHE10PayloadsType, @Nonnull ErrorList errorList) {
        Object object;
        String string;
        XHE10PartyType xHE10PartyType;
        XHE10PartyType xHE10PartyType2;
        Object object2;
        String string2;
        Object object3;
        ValueEnforcer.notNull((Object)xHE10XHEType, (String)"ExchangeHeaderEnvelope");
        ValueEnforcer.notNull((Object)xHE10PayloadsType, (String)"Payloads");
        ValueEnforcer.notNull((Object)errorList, (String)"ErrorList");
        if (!this.isValidXHEVersionID(xHE10XHEType.getXHEVersionIDValue())) {
            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/XHEVersionID", EDBNAllianceXHEDataReadError.INVALID_XHE_VERSION_ID, xHE10XHEType.getXHEVersionIDValue()));
        }
        if ((object3 = xHE10XHEType.getCustomizationID()) == null) {
            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/CustomizationID", EDBNAllianceXHEDataReadError.CUSTOMIZATION_ID_MISSING, new Object[0]));
        } else {
            string2 = object3.getSchemeID();
            if (!this.isValidCustomizationIDSchemaID(string2)) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/CustomizationID/SchemaID", EDBNAllianceXHEDataReadError.INVALID_CUSTOMIZATION_ID_SCHEMA_ID, string2));
            }
            if (!this.isValidCustomizationID((String)(object2 = object3.getValue()))) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/CustomizationID/Value", EDBNAllianceXHEDataReadError.INVALID_CUSTOMIZATION_ID_VALUE, object2));
            }
        }
        object3 = xHE10XHEType.getProfileID();
        if (object3 == null) {
            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/ProfileID", EDBNAllianceXHEDataReadError.PROFILE_ID_MISSING, new Object[0]));
        } else {
            string2 = object3.getValue();
            if (!this.isValidProfileID(string2)) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/ProfileID/Value", EDBNAllianceXHEDataReadError.INVALID_PROFILE_ID_VALUE, string2));
            }
        }
        object3 = xHE10XHEType.getHeader();
        if (object3 == null) {
            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header", EDBNAllianceXHEDataReadError.HEADER_MISSING, new Object[0]));
        } else {
            String string3;
            int n;
            string2 = object3.getIDValue();
            if (!this.isValidHeaderID(string2)) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ID", EDBNAllianceXHEDataReadError.INVALID_HEADER_ID, string2));
            }
            if (!this.isValidCreationDateTime((XMLOffsetDateTime)(object2 = object3.getCreationDateTimeValue()))) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/CreationDateTime", EDBNAllianceXHEDataReadError.INVALID_CREATION_DATE_TIME, string2));
            }
            if ((xHE10PartyType2 = object3.getFromParty()) != null) {
                n = xHE10PartyType2.getPartyIdentificationCount();
                if (n != 1) {
                    errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/FromParty/PartyIdentification", EDBNAllianceXHEDataReadError.INVALID_FROM_PARTY_COUNT, Integer.toString(n)));
                }
                if (n > 0) {
                    xHE10PartyType = xHE10PartyType2.getPartyIdentificationAtIndex(0).getID();
                    string = xHE10PartyType.getSchemeID();
                    if (!this.isValidFromPartySchemaID(string)) {
                        errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/FromParty/PartyIdentification/ID/schemaID", EDBNAllianceXHEDataReadError.INVALID_FROM_PARTY_SCHEMA_ID, string));
                    }
                    if (!this.isValidFromPartyValue(string, (String)(object = xHE10PartyType.getValue()))) {
                        errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/FromParty/PartyIdentification/ID", EDBNAllianceXHEDataReadError.INVALID_FROM_PARTY_VALUE, object));
                    } else {
                        string3 = this.m_aIdentifierFactory.createParticipantIdentifier(string, (String)object);
                        if (string3 == null) {
                            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/FromParty/PartyIdentification/ID", EDBNAllianceXHEDataReadError.INVALID_FROM_PARTY_VALUE, CIdentifier.getURIEncoded((String)string, (String)object)));
                        }
                    }
                }
            }
            if ((n = object3.getToPartyCount()) != 1) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ToParty", EDBNAllianceXHEDataReadError.INVALID_TO_PARTY_COUNT, Integer.toString(n)));
            }
            if (n > 0) {
                xHE10PartyType = object3.getToPartyAtIndex(0);
                int n2 = xHE10PartyType.getPartyIdentificationCount();
                if (n2 != 1) {
                    errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ToParty/PartyIdentification", EDBNAllianceXHEDataReadError.INVALID_TO_PARTY_IDENTIFICATION_COUNT, Integer.toString(n2)));
                }
                if (n2 > 0) {
                    String string4;
                    object = xHE10PartyType.getPartyIdentificationAtIndex(0).getID();
                    string3 = object.getSchemeID();
                    if (!this.isValidToPartySchemaID(string3)) {
                        errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ToParty/PartyIdentification/ID/schemaID", EDBNAllianceXHEDataReadError.INVALID_TO_PARTY_SCHEMA_ID, string3));
                    }
                    if (!this.isValidToPartyValue(string3, string4 = object.getValue())) {
                        errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ToParty/PartyIdentification/ID", EDBNAllianceXHEDataReadError.INVALID_TO_PARTY_VALUE, string4));
                    } else {
                        IParticipantIdentifier iParticipantIdentifier = this.m_aIdentifierFactory.createParticipantIdentifier(string3, string4);
                        if (iParticipantIdentifier == null) {
                            errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Header/ToParty/PartyIdentification/ID", EDBNAllianceXHEDataReadError.INVALID_TO_PARTY_VALUE, CIdentifier.getURIEncoded((String)string3, (String)string4)));
                        }
                    }
                }
            }
        }
        object3 = xHE10PayloadsType.getPayload();
        int n = 1;
        object2 = object3.iterator();
        while (object2.hasNext()) {
            xHE10PartyType2 = (XHE10PayloadType)object2.next();
            String string5 = xHE10PartyType2.getIDValue();
            if (!this.isValidPayloadIDValue(string5)) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Payloads/Payload[" + n + "]/ID", EDBNAllianceXHEDataReadError.INVALID_PAYLOAD_ID_VALUE, string5));
            }
            if ((string = (xHE10PartyType = xHE10PartyType2.getContentTypeCode()).getListID()) != null && !this.isValidContentTypeCodeListID(string)) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Payloads/Payload[" + n + "]/ContentTypeCode/listID", EDBNAllianceXHEDataReadError.INVALID_CONTENT_TYPE_CODE_LIST_ID, string));
            }
            if (!this.isValidContentTypeCodeValue(string, (String)(object = xHE10PartyType.getValue()))) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Payloads/Payload[" + n + "]/ContentTypeCode", EDBNAllianceXHEDataReadError.INVALID_CONTENT_TYPE_CODE_VALUE, object));
            }
            if ((xHE10PartyType = xHE10PartyType2.getInstanceEncryptionIndicator()) == null) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError("XHE/Payloads/Payload[" + n + "]/InstanceEncryptionIndicator", EDBNAllianceXHEDataReadError.INSTANCE_ENCRYPTION_INDICATOR_MISSING, new Object[0]));
            }
            if ((string = xHE10PartyType2.getPayloadContent()) != null && string.hasContentEntries() && !this.isValidBusinessMessage((Element)(object = (Element)string.getContentAtIndex(0)))) {
                errorList.add((Object)DBNAllianceXHEDataReader._toError(null, EDBNAllianceXHEDataReadError.INVALID_BUSINESS_MESSAGE, new Object[0]));
            }
            ++n;
        }
    }

    @Nonnull
    public DBNAllianceXHEData extractData(@Nonnull XHE10XHEType xHE10XHEType, @Nonnull XHE10PayloadsType xHE10PayloadsType) throws DBNAllianceXHEDataReadException {
        ValueEnforcer.notNull((Object)xHE10XHEType, (String)"ExchangeHeaderEnvelope");
        ValueEnforcer.notNull((Object)xHE10PayloadsType, (String)"Payloads");
        if (this.isPerformValueChecks()) {
            ErrorList errorList = new ErrorList();
            this.validateData(xHE10XHEType, xHE10PayloadsType, errorList);
            int n = errorList.getErrorCount();
            if (n > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                errorList.forEach(iError -> {
                    if (iError.isError()) {
                        String string = iError.getAsStringLocaleIndepdent();
                        LOGGER.error("DBNAlliance XHE validation " + string);
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append('\n');
                        }
                        stringBuilder.append(string);
                    }
                });
                IError iError2 = (IError)errorList.findFirst(IHasErrorLevel::isError);
                EDBNAllianceXHEDataReadError eDBNAllianceXHEDataReadError = EDBNAllianceXHEDataReadError.getFromIDOrDefault(iError2.getErrorID(), EDBNAllianceXHEDataReadError.GENERIC_XHE_ERROR);
                throw new DBNAllianceXHEDataReadException(stringBuilder.toString(), eDBNAllianceXHEDataReadError);
            }
        }
        return this.extractDataUnchecked(xHE10XHEType, xHE10PayloadsType);
    }

    @Nonnull
    public DBNAllianceXHEData extractDataUnchecked(@Nonnull XHE10XHEType xHE10XHEType, @Nonnull XHE10PayloadsType xHE10PayloadsType) {
        XHE10PayloadType xHE10PayloadType;
        XHE10PartyType xHE10PartyType;
        ValueEnforcer.notNull((Object)xHE10XHEType, (String)"ExchangeHeaderEnvelope");
        ValueEnforcer.notNull((Object)xHE10PayloadsType, (String)"Payloads");
        DBNAllianceXHEData dBNAllianceXHEData = new DBNAllianceXHEData(this.m_aIdentifierFactory);
        Object object = xHE10XHEType.getHeader();
        if (object != null) {
            dBNAllianceXHEData.setID(object.getIDValue());
            dBNAllianceXHEData.setCreationDateAndTime(object.getCreationDateTimeValue());
            xHE10PartyType = object.getFromParty();
            if (xHE10PartyType != null && xHE10PartyType.hasPartyIdentificationEntries()) {
                xHE10PayloadType = xHE10PartyType.getPartyIdentificationAtIndex(0).getID();
                dBNAllianceXHEData.setFromParty(xHE10PayloadType.getSchemeID(), xHE10PayloadType.getValue());
            }
            if (object.hasToPartyEntries() && (xHE10PartyType = object.getToPartyAtIndex(0)).hasPartyIdentificationEntries()) {
                xHE10PayloadType = xHE10PartyType.getPartyIdentificationAtIndex(0).getID();
                dBNAllianceXHEData.setFromParty(xHE10PayloadType.getSchemeID(), xHE10PayloadType.getValue());
            }
        }
        object = xHE10PayloadsType.getPayload();
        xHE10PartyType = object.iterator();
        while (xHE10PartyType.hasNext()) {
            XHE10PayloadContentType xHE10PayloadContentType;
            XHE10InstanceEncryptionMethodType xHE10InstanceEncryptionMethodType;
            XHE10InstanceEncryptionIndicatorType xHE10InstanceEncryptionIndicatorType;
            XHE10ProfileIDType xHE10ProfileIDType;
            XHE10CustomizationIDType xHE10CustomizationIDType;
            XHE10ContentTypeCodeType xHE10ContentTypeCodeType;
            xHE10PayloadType = (XHE10PayloadType)xHE10PartyType.next();
            DBNAlliancePayload dBNAlliancePayload = new DBNAlliancePayload(this.m_aIdentifierFactory);
            if (xHE10PayloadType.hasDescriptionEntries()) {
                dBNAlliancePayload.setDescription(xHE10PayloadType.getDescriptionAtIndex(0).getValue());
            }
            if ((xHE10ContentTypeCodeType = xHE10PayloadType.getContentTypeCode()) != null) {
                dBNAlliancePayload.setContentTypeCode(xHE10ContentTypeCodeType.getListID(), xHE10ContentTypeCodeType.getValue());
            }
            if ((xHE10CustomizationIDType = xHE10PayloadType.getCustomizationID()) != null) {
                dBNAlliancePayload.setCustomizationID(xHE10CustomizationIDType.getSchemeID(), xHE10CustomizationIDType.getValue());
            }
            if ((xHE10ProfileIDType = xHE10PayloadType.getProfileID()) != null) {
                dBNAlliancePayload.setProfileID(xHE10ProfileIDType.getSchemeID(), xHE10ProfileIDType.getValue());
            }
            if ((xHE10InstanceEncryptionIndicatorType = xHE10PayloadType.getInstanceEncryptionIndicator()) != null) {
                dBNAlliancePayload.setInstanceEncryptionIndicator(xHE10InstanceEncryptionIndicatorType.isValue());
            }
            if ((xHE10InstanceEncryptionMethodType = xHE10PayloadType.getInstanceEncryptionMethod()) != null) {
                dBNAlliancePayload.setInstanceEncryptionMethod(xHE10InstanceEncryptionMethodType.getValue());
            }
            if ((xHE10PayloadContentType = xHE10PayloadType.getPayloadContent()) != null && xHE10PayloadContentType.hasContentEntries()) {
                dBNAlliancePayload.setPayloadContent((Element)xHE10PayloadContentType.getContentAtIndex(0));
            }
            dBNAllianceXHEData.addPayload(dBNAlliancePayload);
        }
        return dBNAllianceXHEData;
    }
}

