/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.xhe.write;

import com.helger.commons.ValueEnforcer;
import com.helger.peppol.xhe.DBNAlliancePayload;
import com.helger.peppol.xhe.DBNAllianceXHEData;
import com.helger.xhe.v10.XHE10XHEType;
import com.helger.xhe.v10.cac.XHE10HeaderType;
import com.helger.xhe.v10.cac.XHE10PartyIdentificationType;
import com.helger.xhe.v10.cac.XHE10PartyType;
import com.helger.xhe.v10.cac.XHE10PayloadContentType;
import com.helger.xhe.v10.cac.XHE10PayloadType;
import com.helger.xhe.v10.cac.XHE10PayloadsType;
import com.helger.xhe.v10.cbc.XHE10ContentTypeCodeType;
import com.helger.xhe.v10.cbc.XHE10CustomizationIDType;
import com.helger.xhe.v10.cbc.XHE10DescriptionType;
import com.helger.xhe.v10.cbc.XHE10IDType;
import com.helger.xhe.v10.cbc.XHE10ProfileIDType;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class DBNAllianceXHEDocumentWriter {
    private DBNAllianceXHEDocumentWriter() {
    }

    @Nonnull
    public static XHE10XHEType createExchangeHeaderEnvelope(@Nonnull DBNAllianceXHEData dBNAllianceXHEData) {
        ValueEnforcer.notNull((Object)dBNAllianceXHEData, (String)"Data");
        if (!dBNAllianceXHEData.areAllFieldsSet()) {
            throw new IllegalArgumentException("Not all data fields are set!");
        }
        XHE10XHEType xHE10XHEType = new XHE10XHEType();
        xHE10XHEType.setXHEVersionID("1.0");
        XHE10CustomizationIDType xHE10CustomizationIDType = new XHE10CustomizationIDType();
        xHE10CustomizationIDType.setSchemeID("bdx-docid-qns");
        xHE10CustomizationIDType.setValue("http://docs.oasisopen.org/bdxr/ns/XHE/1/ExchangeHeaderEnvelope::XHE##dbnalliance-envelope-1.0");
        xHE10XHEType.setCustomizationID(xHE10CustomizationIDType);
        xHE10XHEType.setProfileID("dbnalliance-envelope-1.0");
        xHE10CustomizationIDType = new XHE10HeaderType();
        xHE10CustomizationIDType.setID(dBNAllianceXHEData.getID());
        xHE10CustomizationIDType.setCreationDateTime(dBNAllianceXHEData.getCreationDateTime());
        XHE10PartyType xHE10PartyType = new XHE10PartyType();
        Object object = new XHE10PartyIdentificationType();
        XHE10IDType object22 = new XHE10IDType();
        object22.setSchemeID(dBNAllianceXHEData.getFromPartyScheme());
        object22.setValue(dBNAllianceXHEData.getFromPartyValue());
        object.setID(object22);
        xHE10PartyType.addPartyIdentification((XHE10PartyIdentificationType)object);
        xHE10CustomizationIDType.setFromParty(xHE10PartyType);
        xHE10PartyType = new XHE10PartyType();
        object = new XHE10PartyIdentificationType();
        XHE10IDType xHE10IDType = new XHE10IDType();
        xHE10IDType.setSchemeID(dBNAllianceXHEData.getToPartyScheme());
        xHE10IDType.setValue(dBNAllianceXHEData.getToPartyValue());
        object.setID(xHE10IDType);
        xHE10PartyType.addPartyIdentification((XHE10PartyIdentificationType)object);
        xHE10CustomizationIDType.addToParty(xHE10PartyType);
        xHE10XHEType.setHeader((XHE10HeaderType)xHE10CustomizationIDType);
        xHE10CustomizationIDType = new XHE10PayloadsType();
        int n = 1;
        for (DBNAlliancePayload dBNAlliancePayload : dBNAllianceXHEData.getPayloads()) {
            XHE10DescriptionType xHE10DescriptionType;
            XHE10PayloadType xHE10PayloadType = new XHE10PayloadType();
            xHE10PayloadType.setID(Integer.toString(n++));
            xHE10PayloadType.setInstanceEncryptionIndicator(dBNAlliancePayload.isInstanceEncryptionIndicator());
            if (dBNAlliancePayload.hasInstanceEncryptionMethod()) {
                xHE10PayloadType.setInstanceEncryptionMethod(dBNAlliancePayload.getInstanceEncryptionMethod());
            }
            if (dBNAlliancePayload.hasDescription()) {
                xHE10DescriptionType = new XHE10DescriptionType();
                xHE10DescriptionType.setValue(dBNAlliancePayload.getDescription());
                xHE10PayloadType.addDescription(xHE10DescriptionType);
            }
            xHE10DescriptionType = new XHE10ContentTypeCodeType();
            xHE10DescriptionType.setListID(dBNAlliancePayload.getContentTypeCodeListID());
            xHE10DescriptionType.setValue(dBNAlliancePayload.getContentTypeCode());
            xHE10PayloadType.setContentTypeCode((XHE10ContentTypeCodeType)xHE10DescriptionType);
            if (dBNAlliancePayload.hasCustomizationID()) {
                xHE10DescriptionType = new XHE10CustomizationIDType();
                xHE10DescriptionType.setSchemeID(dBNAlliancePayload.getCustomizationIDSchemeID());
                xHE10DescriptionType.setValue(dBNAlliancePayload.getCustomizationID());
                xHE10PayloadType.setCustomizationID((XHE10CustomizationIDType)xHE10DescriptionType);
            }
            if (dBNAlliancePayload.hasProfileID()) {
                xHE10DescriptionType = new XHE10ProfileIDType();
                xHE10DescriptionType.setSchemeID(dBNAlliancePayload.getProfileIDSchemeID());
                xHE10DescriptionType.setValue(dBNAlliancePayload.getProfileID());
                xHE10PayloadType.setProfileID((XHE10ProfileIDType)xHE10DescriptionType);
            }
            xHE10DescriptionType = new XHE10PayloadContentType();
            xHE10DescriptionType.addContent((Object)dBNAlliancePayload.getPayloadContent());
            xHE10PayloadType.setPayloadContent((XHE10PayloadContentType)xHE10DescriptionType);
            xHE10CustomizationIDType.addPayload(xHE10PayloadType);
        }
        xHE10XHEType.setPayloads((XHE10PayloadsType)xHE10CustomizationIDType);
        return xHE10XHEType;
    }
}

