/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.CIdentifier;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IIdentifier
extends Serializable {
    @Nonnull
    public String getScheme();

    default public boolean hasScheme() {
        return StringHelper.hasText((String)this.getScheme());
    }

    default public boolean hasScheme(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getScheme(), (Object)string);
    }

    @Nonnull
    public String getValue();

    default public boolean hasValue() {
        return StringHelper.hasText((String)this.getValue());
    }

    default public boolean hasValue(@Nullable String string) {
        return EqualsHelper.equals((Object)this.getValue(), (Object)string);
    }

    @Nonnull
    @Nonempty
    default public String getURIEncoded() {
        return CIdentifier.getURIEncoded(this);
    }

    @Nonnull
    default public String getURIPercentEncoded() {
        return CIdentifier.getURIPercentEncoded(this);
    }
}

