/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.commons.string.ToStringGenerator;
import com.helger.peppolid.bdxr.smp1.BDXR1IdentifierHelper;
import com.helger.peppolid.bdxr.smp1.doctype.BDXR1DocumentTypeIdentifier;
import com.helger.peppolid.bdxr.smp1.participant.BDXR1ParticipantIdentifier;
import com.helger.peppolid.bdxr.smp1.process.BDXR1ProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BDXR1IdentifierFactory
implements IIdentifierFactory {
    public static final BDXR1IdentifierFactory INSTANCE = new BDXR1IdentifierFactory();

    @Override
    @Nonnull
    public String getDefaultDocumentTypeIdentifierScheme() {
        return "bdx-docid-qns";
    }

    @Override
    public boolean isDocumentTypeIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-docid-qns".equals(string);
    }

    @Override
    public boolean isDocumentTypeIdentifierSchemeValid(@Nullable String string) {
        return BDXR1IdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isDocumentTypeIdentifierValueValid(@Nullable String string) {
        return BDXR1IdentifierHelper.isValidIdentifierValue(string);
    }

    @Override
    @Nullable
    public BDXR1DocumentTypeIdentifier createDocumentTypeIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isDocumentTypeIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isDocumentTypeIdentifierSchemeValid(string3) && this.isDocumentTypeIdentifierValueValid(string4)) {
            return new BDXR1DocumentTypeIdentifier(string3, string4);
        }
        return null;
    }

    @Override
    public boolean isParticipantIdentifierCaseInsensitive(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @Override
    public boolean isParticipantIdentifierSchemeValid(@Nullable String string) {
        return BDXR1IdentifierHelper.isValidIdentifierScheme(string);
    }

    @Override
    public boolean isParticipantIdentifierValueValid(@Nullable String string) {
        return BDXR1IdentifierHelper.isValidIdentifierValue(string);
    }

    @Override
    @Nullable
    public BDXR1ParticipantIdentifier createParticipantIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isParticipantIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isParticipantIdentifierSchemeValid(string3) && this.isParticipantIdentifierValueValid(string4)) {
            return new BDXR1ParticipantIdentifier(string3, string4);
        }
        return null;
    }

    @Override
    @Nonnull
    public String getDefaultProcessIdentifierScheme() {
        return "bdx-procid-transport";
    }

    @Override
    public boolean isProcessIdentifierCaseInsensitive(@Nullable String string) {
        return "bdx-procid-transport".equals(string);
    }

    @Override
    public boolean isProcessIdentifierValueValid(String string) {
        return BDXR1IdentifierHelper.isValidIdentifierValue(string);
    }

    @Override
    @Nullable
    public BDXR1ProcessIdentifier createProcessIdentifier(@Nullable String string, @Nullable String string2) {
        String string3 = this.nullNotEmpty(string);
        String string4 = this.nullNotEmpty(this.isProcessIdentifierCaseInsensitive(string3) ? this.getUnifiedValue(string2) : string2);
        if (this.isProcessIdentifierSchemeValid(string3) && this.isProcessIdentifierValueValid(string4)) {
            return new BDXR1ProcessIdentifier(string3, string4);
        }
        return null;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

