/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.factory;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasDisplayName;
import com.helger.peppolid.factory.BDXR1IdentifierFactory;
import com.helger.peppolid.factory.BDXR2IdentifierFactory;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ESMPIdentifierType implements IHasID<String>,
IHasDisplayName
{
    SIMPLE("simple", "Simple", SimpleIdentifierFactory.INSTANCE),
    PEPPOL("peppol", "Peppol", PeppolIdentifierFactory.INSTANCE),
    BDXR1("bdxr1", "OASIS BDXR v1", BDXR1IdentifierFactory.INSTANCE),
    BDXR2("bdxr2", "OASIS BDXR v2", BDXR2IdentifierFactory.INSTANCE);

    private final String m_sID;
    private final String m_sDisplayName;
    private final IIdentifierFactory m_aIF;

    private ESMPIdentifierType(@Nonnull String string2, String string3, IIdentifierFactory iIdentifierFactory) {
        this.m_sID = string2;
        this.m_sDisplayName = string3;
        this.m_aIF = iIdentifierFactory;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public IIdentifierFactory getIdentifierFactory() {
        return this.m_aIF;
    }

    @Nullable
    public static ESMPIdentifierType getFromIDOrNull(@Nullable String string) {
        return ESMPIdentifierType.getFromIDOrDefault(string, null);
    }

    @Nullable
    public static ESMPIdentifierType getFromIDOrDefault(@Nullable String string, @Nullable ESMPIdentifierType eSMPIdentifierType) {
        if ("bdxr".equals(string)) {
            return BDXR1;
        }
        return (ESMPIdentifierType)EnumHelper.getFromIDOrDefault(ESMPIdentifierType.class, (Object)string, (Enum)eSMPIdentifierType);
    }
}

