/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.version.Version;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.peppol.EPeppolCodeListItemState;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifier;
import java.time.LocalDate;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPeppolPredefinedDocumentTypeIdentifier
extends IDocumentTypeIdentifier,
IPeppolIdentifier,
IPeppolDocumentTypeIdentifierParts {
    @Override
    default public boolean hasDefaultScheme() {
        return true;
    }

    @Nullable
    public String getCommonName();

    @Nonnull
    public PeppolDocumentTypeIdentifier getAsDocumentTypeIdentifier();

    @Nonnull
    @Deprecated
    default public Version getSince() {
        return this.getInitialRelease();
    }

    @Nonnull
    public Version getInitialRelease();

    default public boolean isDeprecated() {
        return this.getState().isDeprecated();
    }

    @Nonnull
    public EPeppolCodeListItemState getState();

    @Nullable
    @Deprecated
    default public Version getDeprecatedSince() {
        return this.getDeprecationRelease();
    }

    @Nullable
    public Version getDeprecationRelease();

    default public boolean hasRemovalDate() {
        return this.getRemovalDate() != null;
    }

    @Nullable
    public LocalDate getRemovalDate();

    @Deprecated
    default public boolean isIssuedByOpenPEPPOL() {
        return this.isIssuedByOpenPeppol();
    }

    public boolean isIssuedByOpenPeppol();

    @CheckForSigned
    public int getBISVersion();

    @Nonnull
    @Nonempty
    public String getDomainCommunity();

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public ICommonsList<IProcessIdentifier> getAllProcessIDs();
}

