/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolDocumentTypeIdentifierParts;
import com.helger.peppolid.peppol.doctype.PeppolDocumentTypeIdentifierParts;
import com.helger.xsds.peppol.id1.DocumentIdentifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolDocumentTypeIdentifier
extends DocumentIdentifierType
implements IPeppolIdentifier,
IMutableIdentifier,
IDocumentTypeIdentifier,
Comparable<PeppolDocumentTypeIdentifier>,
ICloneable<PeppolDocumentTypeIdentifier> {
    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isDocumentTypeIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Document Type identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isDocumentTypeIdentifierValueValid(string)) {
            throw new IllegalArgumentException("Peppol Document Type identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) {
        this(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolDocumentTypeIdentifier(@Nullable String string, @Nonnull String string2) {
        this(true, PeppolDocumentTypeIdentifier._verifyScheme(string), PeppolDocumentTypeIdentifier._verifyValue(string2));
    }

    protected PeppolDocumentTypeIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("busdox-docid-qns");
    }

    @Override
    public int compareTo(@Nonnull PeppolDocumentTypeIdentifier peppolDocumentTypeIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolDocumentTypeIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolDocumentTypeIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    public IPeppolDocumentTypeIdentifierParts getParts() {
        return PeppolDocumentTypeIdentifierParts.extractFromIdentifier(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolDocumentTypeIdentifier getClone() {
        return new PeppolDocumentTypeIdentifier(this);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Nullable
    public static PeppolDocumentTypeIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (PeppolIdentifierFactory.INSTANCE.isDocumentTypeIdentifierSchemeValid(string) && PeppolIdentifierFactory.INSTANCE.isDocumentTypeIdentifierValueValid(string2)) {
            return new PeppolDocumentTypeIdentifier(true, string, string2);
        }
        return null;
    }
}

