/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.doctype;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.peppolid.peppol.doctype.EPredefinedDocumentTypeIdentifier;
import com.helger.peppolid.peppol.doctype.IPeppolPredefinedDocumentTypeIdentifier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedDocumentTypeIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedDocumentTypeIdentifier> CODES = new CommonsHashMap();
    private static final PredefinedDocumentTypeIdentifierManager INSTANCE;

    private PredefinedDocumentTypeIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedDocumentTypeIdentifier> getAllDocumentTypeIdentifiers() {
        return CODES.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllDocumentTypeIdentifierIDs() {
        return CODES.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedDocumentTypeIdentifier getDocumentTypeIdentifierOfID(@Nullable String string) {
        if (string != null) {
            return (IPeppolPredefinedDocumentTypeIdentifier)CODES.get((Object)string);
        }
        return null;
    }

    public static boolean containsDocumentTypeIdentifierWithID(@Nullable String string) {
        return PredefinedDocumentTypeIdentifierManager.getDocumentTypeIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier : EPredefinedDocumentTypeIdentifier.values()) {
            CODES.put((Object)ePredefinedDocumentTypeIdentifier.getValue(), (Object)ePredefinedDocumentTypeIdentifier);
        }
        INSTANCE = new PredefinedDocumentTypeIdentifierManager();
    }
}

