/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.participant;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.peppolid.IMutableIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.peppolid.peppol.IPeppolIdentifier;
import com.helger.peppolid.peppol.validator.IdentifierValidator;
import com.helger.xsds.peppol.id1.ParticipantIdentifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PeppolParticipantIdentifier
extends ParticipantIdentifierType
implements IParticipantIdentifier,
IPeppolIdentifier,
IMutableIdentifier,
Comparable<PeppolParticipantIdentifier>,
ICloneable<PeppolParticipantIdentifier> {
    @Nonnull
    private static String _verifyScheme(@Nullable String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isParticipantIdentifierSchemeValid(string)) {
            throw new IllegalArgumentException("Peppol Participant identifier scheme '" + string + "' is invalid!");
        }
        return string;
    }

    @Nonnull
    private static String _verifyValue(@Nonnull String string) {
        if (!PeppolIdentifierFactory.INSTANCE.isParticipantIdentifierValueValid(string)) {
            throw new IllegalArgumentException("Peppol Participant identifier value '" + string + "' is invalid!");
        }
        return string;
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        this(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue());
    }

    @DevelopersNote(value="Don't invoke manually. Always use the IdentifierFactory!")
    public PeppolParticipantIdentifier(@Nullable String string, @Nonnull String string2) {
        this(true, PeppolParticipantIdentifier._verifyScheme(string), PeppolParticipantIdentifier._verifyValue(string2));
    }

    protected PeppolParticipantIdentifier(boolean bl, @Nonnull String string, @Nonnull String string2) {
        this.setScheme(string);
        this.setValue(string2);
    }

    @Override
    public boolean hasDefaultScheme() {
        return this.hasScheme("iso6523-actorid-upis");
    }

    public boolean isSemanticallyValid() {
        return IdentifierValidator.isValidParticipantIdentifier(this);
    }

    @Nullable
    public String getIssuingAgencyID() {
        if (this.hasDefaultScheme()) {
            return (String)StringHelper.getExploded((char)':', (String)this.getValue(), (int)2).getAtIndex(0);
        }
        return null;
    }

    @Nullable
    public String getLocalParticipantID() {
        if (this.hasDefaultScheme()) {
            return (String)StringHelper.getExploded((char)':', (String)this.getValue(), (int)2).getAtIndex(1);
        }
        return null;
    }

    @Override
    public int compareTo(@Nonnull PeppolParticipantIdentifier peppolParticipantIdentifier) {
        int n = CompareHelper.compare((Comparable)((Object)this.getScheme()), (Comparable)((Object)peppolParticipantIdentifier.getScheme()));
        if (n == 0) {
            n = CompareHelper.compare((Comparable)((Object)this.getValue()), (Comparable)((Object)peppolParticipantIdentifier.getValue()));
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public PeppolParticipantIdentifier getClone() {
        return new PeppolParticipantIdentifier(this);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Nullable
    public static PeppolParticipantIdentifier createIfValid(@Nullable String string, @Nullable String string2) {
        if (PeppolIdentifierFactory.INSTANCE.isParticipantIdentifierSchemeValid(string) && PeppolIdentifierFactory.INSTANCE.isParticipantIdentifierValueValid(string2)) {
            return new PeppolParticipantIdentifier(true, string, string2);
        }
        return null;
    }

    public static boolean isValidValueWithDefaultScheme(@Nonnull String string) {
        ICommonsList iCommonsList = StringHelper.getExploded((char)':', (String)string, (int)2);
        if (iCommonsList.size() != 2) {
            return false;
        }
        String string2 = (String)iCommonsList.get(0);
        if (string2.length() != 4 || !StringParser.isUnsignedInt((String)string2)) {
            return false;
        }
        String string3 = ((String)iCommonsList.get(1)).trim();
        return string3.length() > 0;
    }
}

