/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.process;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.peppolid.peppol.process.EPredefinedProcessIdentifier;
import com.helger.peppolid.peppol.process.IPeppolPredefinedProcessIdentifier;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PredefinedProcessIdentifierManager {
    private static final ICommonsMap<String, IPeppolPredefinedProcessIdentifier> CODES = new CommonsHashMap();
    private static final PredefinedProcessIdentifierManager INSTANCE;

    private PredefinedProcessIdentifierManager() {
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsCollection<IPeppolPredefinedProcessIdentifier> getAllProcessIdentifiers() {
        return CODES.copyOfValues();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllProcessIdentifierIDs() {
        return CODES.copyOfKeySet();
    }

    @Nullable
    public static IPeppolPredefinedProcessIdentifier getProcessIdentifierOfID(@Nullable String string) {
        if (string != null) {
            for (Map.Entry entry : CODES.entrySet()) {
                if (!string.equals(entry.getKey())) continue;
                return (IPeppolPredefinedProcessIdentifier)entry.getValue();
            }
        }
        return null;
    }

    public static boolean containsProcessIdentifierWithID(@Nullable String string) {
        return PredefinedProcessIdentifierManager.getProcessIdentifierOfID(string) != null;
    }

    static {
        for (EPredefinedProcessIdentifier ePredefinedProcessIdentifier : EPredefinedProcessIdentifier.values()) {
            CODES.put((Object)ePredefinedProcessIdentifier.getValue(), (Object)ePredefinedProcessIdentifier);
        }
        INSTANCE = new PredefinedProcessIdentifierManager();
    }
}

