/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppolid.peppol.validator;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.peppolid.peppol.participant.PeppolParticipantIdentifier;
import com.helger.peppolid.peppol.validator.IParticipantIdentifierValidatorSPI;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class IdentifierValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierValidator.class);
    private static final ICommonsList<IParticipantIdentifierValidatorSPI> PID_VALIDATOR = ServiceLoaderHelper.getAllSPIImplementations(IParticipantIdentifierValidatorSPI.class);
    private static final IdentifierValidator INSTANCE;

    private IdentifierValidator() {
    }

    public static boolean isValidParticipantIdentifier(@Nonnull PeppolParticipantIdentifier peppolParticipantIdentifier) {
        ValueEnforcer.notNull((Object)peppolParticipantIdentifier, (String)"ParticipantID");
        if (!peppolParticipantIdentifier.hasDefaultScheme()) {
            return true;
        }
        boolean bl = false;
        String string = peppolParticipantIdentifier.getIssuingAgencyID();
        String string2 = peppolParticipantIdentifier.getLocalParticipantID();
        for (IParticipantIdentifierValidatorSPI iParticipantIdentifierValidatorSPI : PID_VALIDATOR) {
            if (!iParticipantIdentifierValidatorSPI.isSupportedIssuingAgency(string)) continue;
            if (iParticipantIdentifierValidatorSPI.isValueValid(string2)) {
                return true;
            }
            bl = true;
        }
        return !bl;
    }

    static {
        if (PID_VALIDATOR.isNotEmpty()) {
            LOGGER.info("Loaded " + PID_VALIDATOR.size() + " SPI implementations of IParticipantIdentifierValidatorSPI");
        }
        INSTANCE = new IdentifierValidator();
    }
}

