/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.jaxb.validation.IValidationEventHandlerFactory;
import com.helger.peppol.sbdh.PeppolSBDHAdditionalAttributes;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import com.helger.peppol.sbdh.read.EPeppolSBDHDocumentReadError;
import com.helger.peppol.sbdh.read.PeppolSBDHDocumentReadException;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.sbdh.SBDMarshaller;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.datatype.XMLGregorianCalendar;
import org.unece.cefact.namespaces.sbdh.DocumentIdentification;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocumentHeader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public class PeppolSBDHDocumentReader {
    private final IIdentifierFactory m_aIdentifierFactory;

    public PeppolSBDHDocumentReader() {
        this((IIdentifierFactory)SimpleIdentifierFactory.INSTANCE);
    }

    public PeppolSBDHDocumentReader(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @OverrideOnDemand
    protected boolean isValidHeaderVersion(@Nullable String string) {
        return "1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidDocumentTypeIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidProcessIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidBusinessMessage(@Nonnull Element element) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidStandard(@Nullable String string, @Nonnull Element element) {
        return EqualsHelper.equals((Object)string, (Object)element.getNamespaceURI());
    }

    @OverrideOnDemand
    protected boolean isValidTypeVersion(@Nullable String string, @Nonnull Element element) {
        return "2.0".equals(string) || "2.1".equals(string) || "2.2".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidType(@Nullable String string, @Nonnull Element element) {
        return EqualsHelper.equals((Object)string, (Object)element.getLocalName());
    }

    @OverrideOnDemand
    protected boolean isValidInstanceIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidCreationDateTime(@Nonnull LocalDateTime localDateTime) {
        return true;
    }

    @Nonnull
    @OverrideOnDemand
    protected SBDMarshaller createSBDMarshaller() {
        SBDMarshaller sBDMarshaller = new SBDMarshaller();
        sBDMarshaller.setValidationEventHandlerFactory((IValidationEventHandlerFactory & Serializable)validationEventHandler -> null);
        return sBDMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull @WillClose InputStream inputStream) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)inputStream, (String)"StandardBusinessDocument");
        try {
            StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(inputStream);
            if (standardBusinessDocument == null) {
                throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
            }
            PeppolSBDHDocument peppolSBDHDocument = this.extractData(standardBusinessDocument);
            return peppolSBDHDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull IReadableResource iReadableResource) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(iReadableResource);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull Node node) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)node, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(node);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull StandardBusinessDocument standardBusinessDocument) throws PeppolSBDHDocumentReadException {
        Object object;
        String string;
        Object object22;
        ValueEnforcer.notNull((Object)standardBusinessDocument, (String)"StandardBusinessDocument");
        PeppolSBDHDocument peppolSBDHDocument = new PeppolSBDHDocument(this.m_aIdentifierFactory);
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = standardBusinessDocument.getStandardBusinessDocumentHeader();
        if (standardBusinessDocumentHeader == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_SBDH);
        }
        if (!this.isValidHeaderVersion(standardBusinessDocumentHeader.getHeaderVersion())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_HEADER_VERSION, standardBusinessDocumentHeader.getHeaderVersion());
        }
        if (standardBusinessDocumentHeader.getSenderCount() != 1) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_COUNT, Integer.toString(standardBusinessDocumentHeader.getSenderCount()));
        }
        Object object3 = standardBusinessDocumentHeader.getSenderAtIndex(0).getIdentifier();
        if (!this.isValidSenderAuthority(object3.getAuthority())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_AUTHORITY, object3.getAuthority());
        }
        if (!this.isValidSenderIdentifier(object3.getAuthority(), object3.getValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_VALUE, object3.getValue());
        }
        peppolSBDHDocument.setSender(object3.getAuthority(), object3.getValue());
        if (standardBusinessDocumentHeader.getReceiverCount() != 1) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_COUNT, Integer.toString(standardBusinessDocumentHeader.getReceiverCount()));
        }
        object3 = standardBusinessDocumentHeader.getReceiverAtIndex(0).getIdentifier();
        if (!this.isValidReceiverAuthority(object3.getAuthority())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_AUTHORITY, object3.getAuthority());
        }
        if (!this.isValidReceiverIdentifier(object3.getAuthority(), object3.getValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_VALUE, object3.getValue());
        }
        peppolSBDHDocument.setReceiver(object3.getAuthority(), object3.getValue());
        object3 = standardBusinessDocumentHeader.getBusinessScope();
        if (object3 == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.BUSINESS_SCOPE_MISSING);
        }
        if (object3.getScopeCount() < 2) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SCOPE_COUNT, Integer.toString(object3.getScopeCount()));
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Object object22 : object3.getScope()) {
            String string2;
            string = object22.getType();
            object = object22.getInstanceIdentifier();
            if ("DOCUMENTID".equals(string)) {
                if (!this.isValidDocumentTypeIdentifier((String)object)) {
                    throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_DOCUMENT_TYPE_IDENTIFIER, (String)object);
                }
                string2 = object22.getIdentifier();
                if (string2 == null) {
                    string2 = "busdox-docid-qns";
                }
                peppolSBDHDocument.setDocumentType(string2, (String)object);
                bl = true;
                continue;
            }
            if ("PROCESSID".equals(string)) {
                if (!this.isValidProcessIdentifier((String)object)) {
                    throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_PROCESS_IDENTIFIER, (String)object);
                }
                string2 = object22.getIdentifier();
                if (string2 == null) {
                    string2 = "cenbii-procid-ubl";
                }
                peppolSBDHDocument.setProcess(string2, (String)object);
                bl2 = true;
                continue;
            }
            if (PeppolSBDHAdditionalAttributes.isReservedAttributeName(string)) continue;
            if (StringHelper.hasText((String)object)) {
                peppolSBDHDocument.additionalAttributes().add(string, (String)object);
                continue;
            }
            peppolSBDHDocument.additionalAttributes().add(string, (String)null);
        }
        if (!bl) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_DOCUMENT_TYPE_IDENTIFIER);
        }
        if (!bl2) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_PROCESS_IDENTIFIER);
        }
        object3 = (Element)standardBusinessDocument.getAny();
        if (!this.isValidBusinessMessage((Element)object3)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_BUSINESS_MESSAGE);
        }
        peppolSBDHDocument.setBusinessMessage((Element)object3);
        DocumentIdentification documentIdentification = standardBusinessDocumentHeader.getDocumentIdentification();
        String string3 = documentIdentification.getStandard();
        if (!this.isValidStandard(string3, (Element)object3)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_STANDARD, string3, object3.getNamespaceURI());
        }
        String string4 = documentIdentification.getTypeVersion();
        if (!this.isValidTypeVersion(string4, (Element)object3)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_TYPE_VERSION, string4);
        }
        object22 = documentIdentification.getType();
        if (!this.isValidType((String)object22, (Element)object3)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_TYPE, (String)object22, object3.getLocalName());
        }
        string = documentIdentification.getInstanceIdentifier();
        if (!this.isValidInstanceIdentifier(string)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_INSTANCE_IDENTIFIER, string);
        }
        object = PDTXMLConverter.getLocalDateTime((XMLGregorianCalendar)documentIdentification.getCreationDateAndTime());
        if (!this.isValidCreationDateTime((LocalDateTime)object)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_CREATION_DATE_TIME, String.valueOf(object));
        }
        peppolSBDHDocument.setDocumentIdentification(string3, string4, (String)object22, string, (LocalDateTime)object);
        return peppolSBDHDocument;
    }
}

