/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.datetime.util.PDTXMLConverter;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.unece.cefact.namespaces.sbdh.BusinessScope;
import org.unece.cefact.namespaces.sbdh.DocumentIdentification;
import org.unece.cefact.namespaces.sbdh.Partner;
import org.unece.cefact.namespaces.sbdh.PartnerIdentification;
import org.unece.cefact.namespaces.sbdh.Scope;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocumentHeader;

@NotThreadSafe
public class PeppolSBDHDocumentWriter {
    private String m_sHeaderVersion = "1.0";

    @Nonnull
    public final String getHeaderVersion() {
        return this.m_sHeaderVersion;
    }

    @Nonnull
    public final PeppolSBDHDocumentWriter setHeaderVersion(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"HeaderVersion");
        this.m_sHeaderVersion = string;
        return this;
    }

    @Nonnull
    public StandardBusinessDocument createStandardBusinessDocument(@Nonnull PeppolSBDHDocument peppolSBDHDocument) {
        ValueEnforcer.notNull((Object)peppolSBDHDocument, (String)"Data");
        if (!peppolSBDHDocument.areAllFieldsSet()) {
            throw new IllegalArgumentException("Not all data fields are set!");
        }
        StandardBusinessDocument standardBusinessDocument = new StandardBusinessDocument();
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = new StandardBusinessDocumentHeader();
        standardBusinessDocumentHeader.setHeaderVersion(this.m_sHeaderVersion);
        Partner partner = new Partner();
        Object object = new PartnerIdentification();
        object.setAuthority(peppolSBDHDocument.getSenderScheme());
        object.setValue(peppolSBDHDocument.getSenderValue());
        partner.setIdentifier((PartnerIdentification)object);
        standardBusinessDocumentHeader.addSender(partner);
        partner = new Partner();
        object = new PartnerIdentification();
        object.setAuthority(peppolSBDHDocument.getReceiverScheme());
        object.setValue(peppolSBDHDocument.getReceiverValue());
        partner.setIdentifier((PartnerIdentification)object);
        standardBusinessDocumentHeader.addReceiver(partner);
        partner = new DocumentIdentification();
        partner.setStandard(peppolSBDHDocument.getStandard());
        partner.setTypeVersion(peppolSBDHDocument.getTypeVersion());
        partner.setType(peppolSBDHDocument.getType());
        partner.setInstanceIdentifier(peppolSBDHDocument.getInstanceIdentifier());
        partner.setCreationDateAndTime(PDTXMLConverter.getXMLCalendar((LocalDateTime)peppolSBDHDocument.getCreationDateAndTime()));
        standardBusinessDocumentHeader.setDocumentIdentification((DocumentIdentification)partner);
        partner = new BusinessScope();
        object = new Scope();
        object.setType("DOCUMENTID");
        object.setInstanceIdentifier(peppolSBDHDocument.getDocumentTypeValue());
        object.setIdentifier(peppolSBDHDocument.getDocumentTypeScheme());
        partner.addScope((Scope)object);
        object = new Scope();
        object.setType("PROCESSID");
        object.setInstanceIdentifier(peppolSBDHDocument.getProcessValue());
        object.setIdentifier(peppolSBDHDocument.getProcessScheme());
        partner.addScope((Scope)object);
        for (Map.Entry entry : peppolSBDHDocument.additionalAttributes().entrySet()) {
            Scope scope = new Scope();
            scope.setType((String)entry.getKey());
            scope.setInstanceIdentifier(StringHelper.getNotNull((String)((String)entry.getValue())));
            partner.addScope(scope);
        }
        standardBusinessDocumentHeader.setBusinessScope((BusinessScope)partner);
        standardBusinessDocument.setStandardBusinessDocumentHeader(standardBusinessDocumentHeader);
        standardBusinessDocument.setAny((Object)peppolSBDHDocument.getBusinessMessage());
        return standardBusinessDocument;
    }
}

