/*
 * Decompiled with CFR 0.152.
 */
package com.helger.peppol.sbdh.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.datetime.XMLOffsetDateTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.sbdh.PeppolSBDHAdditionalAttributes;
import com.helger.peppol.sbdh.PeppolSBDHDocument;
import com.helger.peppol.sbdh.read.EPeppolSBDHDocumentReadError;
import com.helger.peppol.sbdh.read.PeppolSBDHDocumentReadException;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.SimpleIdentifierFactory;
import com.helger.sbdh.SBDMarshaller;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.NotThreadSafe;
import org.unece.cefact.namespaces.sbdh.PartnerIdentification;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocument;
import org.unece.cefact.namespaces.sbdh.StandardBusinessDocumentHeader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@NotThreadSafe
public class PeppolSBDHDocumentReader {
    public static final boolean DEFAULT_PERFORM_VALUE_CHECKS = true;
    private final IIdentifierFactory m_aIdentifierFactory;
    private boolean m_bPerformValueChecks = true;

    @Deprecated
    public PeppolSBDHDocumentReader() {
        this((IIdentifierFactory)SimpleIdentifierFactory.INSTANCE);
    }

    public PeppolSBDHDocumentReader(@Nonnull IIdentifierFactory iIdentifierFactory) {
        this.m_aIdentifierFactory = (IIdentifierFactory)ValueEnforcer.notNull((Object)iIdentifierFactory, (String)"IdentifierFactory");
    }

    @Nonnull
    public final IIdentifierFactory getIdentifierFactory() {
        return this.m_aIdentifierFactory;
    }

    public final boolean isPerformValueChecks() {
        return this.m_bPerformValueChecks;
    }

    @Nonnull
    public final PeppolSBDHDocumentReader setPerformValueChecks(boolean bl) {
        this.m_bPerformValueChecks = bl;
        return this;
    }

    @OverrideOnDemand
    protected boolean isValidHeaderVersion(@Nullable String string) {
        return "1.0".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidSenderIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverAuthority(@Nullable String string) {
        return "iso6523-actorid-upis".equals(string);
    }

    @OverrideOnDemand
    protected boolean isValidReceiverIdentifier(@Nullable String string, @Nullable String string2) {
        return StringHelper.hasText((String)string2);
    }

    @OverrideOnDemand
    protected boolean isValidDocumentTypeIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidProcessIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidBusinessMessage(@Nonnull Element element) {
        return true;
    }

    @OverrideOnDemand
    protected boolean isValidStandard(@Nullable String string, @Nonnull Element element, @Nonnull String string2) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        return string.equals(element.getNamespaceURI()) && string2.startsWith(string);
    }

    @OverrideOnDemand
    protected boolean isValidTypeVersion(@Nullable String string, @Nonnull Element element, @Nonnull String string2) {
        if (StringHelper.hasNoText((String)string)) {
            return false;
        }
        if (string.indexOf(58) >= 0) {
            return false;
        }
        return string2.endsWith(":" + string);
    }

    @OverrideOnDemand
    protected boolean isValidType(@Nullable String string, @Nonnull Element element) {
        return EqualsHelper.equals((Object)string, (Object)element.getLocalName());
    }

    @OverrideOnDemand
    protected boolean isValidInstanceIdentifier(@Nullable String string) {
        return StringHelper.hasText((String)string);
    }

    @OverrideOnDemand
    protected boolean isValidCreationDateTime(@Nonnull XMLOffsetDateTime xMLOffsetDateTime) {
        return true;
    }

    @Nonnull
    @OverrideOnDemand
    protected SBDMarshaller createSBDMarshaller() {
        SBDMarshaller sBDMarshaller = new SBDMarshaller();
        sBDMarshaller.setValidationEventHandlerFactory(validationEventHandler -> null);
        return sBDMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull @WillClose InputStream inputStream) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)inputStream, (String)"StandardBusinessDocument");
        try {
            StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(inputStream);
            if (standardBusinessDocument == null) {
                throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
            }
            PeppolSBDHDocument peppolSBDHDocument = this.extractData(standardBusinessDocument);
            return peppolSBDHDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull IReadableResource iReadableResource) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(iReadableResource);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull Node node) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)node, (String)"StandardBusinessDocument");
        StandardBusinessDocument standardBusinessDocument = (StandardBusinessDocument)this.createSBDMarshaller().read(node);
        if (standardBusinessDocument == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SBD_XML);
        }
        return this.extractData(standardBusinessDocument);
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull StandardBusinessDocumentHeader standardBusinessDocumentHeader, @Nonnull Element element) throws PeppolSBDHDocumentReadException {
        String string;
        Object object2;
        ValueEnforcer.notNull((Object)standardBusinessDocumentHeader, (String)"StandardBusinessDocumentHeader");
        ValueEnforcer.notNull((Object)element, (String)"BusinessMessage");
        PeppolSBDHDocument peppolSBDHDocument = new PeppolSBDHDocument(this.m_aIdentifierFactory);
        if (this.m_bPerformValueChecks && !this.isValidHeaderVersion(standardBusinessDocumentHeader.getHeaderVersion())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_HEADER_VERSION, standardBusinessDocumentHeader.getHeaderVersion());
        }
        if (standardBusinessDocumentHeader.getSenderCount() != 1) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_COUNT, Integer.toString(standardBusinessDocumentHeader.getSenderCount()));
        }
        PartnerIdentification partnerIdentification = standardBusinessDocumentHeader.getSenderAtIndex(0).getIdentifier();
        if (this.m_bPerformValueChecks && !this.isValidSenderAuthority(partnerIdentification.getAuthority())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_AUTHORITY, partnerIdentification.getAuthority());
        }
        if (this.m_bPerformValueChecks && !this.isValidSenderIdentifier(partnerIdentification.getAuthority(), partnerIdentification.getValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SENDER_VALUE, partnerIdentification.getValue());
        }
        peppolSBDHDocument.setSender(partnerIdentification.getAuthority(), partnerIdentification.getValue());
        if (standardBusinessDocumentHeader.getReceiverCount() != 1) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_COUNT, Integer.toString(standardBusinessDocumentHeader.getReceiverCount()));
        }
        partnerIdentification = standardBusinessDocumentHeader.getReceiverAtIndex(0).getIdentifier();
        if (this.m_bPerformValueChecks && !this.isValidReceiverAuthority(partnerIdentification.getAuthority())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_AUTHORITY, partnerIdentification.getAuthority());
        }
        if (this.m_bPerformValueChecks && !this.isValidReceiverIdentifier(partnerIdentification.getAuthority(), partnerIdentification.getValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_RECEIVER_VALUE, partnerIdentification.getValue());
        }
        peppolSBDHDocument.setReceiver(partnerIdentification.getAuthority(), partnerIdentification.getValue());
        partnerIdentification = standardBusinessDocumentHeader.getBusinessScope();
        if (partnerIdentification == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.BUSINESS_SCOPE_MISSING);
        }
        if (partnerIdentification.getScopeCount() < 2) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_SCOPE_COUNT, Integer.toString(partnerIdentification.getScopeCount()));
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Object object2 : partnerIdentification.getScope()) {
            String string2;
            string = object2.getType();
            String string3 = object2.getInstanceIdentifier();
            if ("DOCUMENTID".equals(string)) {
                if (this.m_bPerformValueChecks && !this.isValidDocumentTypeIdentifier(string3)) {
                    throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_DOCUMENT_TYPE_IDENTIFIER, string3);
                }
                string2 = object2.getIdentifier();
                if (string2 == null) {
                    string2 = "busdox-docid-qns";
                }
                peppolSBDHDocument.setDocumentType(string2, string3);
                bl = true;
                continue;
            }
            if ("PROCESSID".equals(string)) {
                if (this.m_bPerformValueChecks && !this.isValidProcessIdentifier(string3)) {
                    throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_PROCESS_IDENTIFIER, string3);
                }
                string2 = object2.getIdentifier();
                if (string2 == null) {
                    string2 = "cenbii-procid-ubl";
                }
                peppolSBDHDocument.setProcess(string2, string3);
                bl2 = true;
                continue;
            }
            if (PeppolSBDHAdditionalAttributes.isReservedAttributeName(string)) continue;
            if (StringHelper.hasText((String)string3)) {
                peppolSBDHDocument.additionalAttributes().add(string, string3);
                continue;
            }
            peppolSBDHDocument.additionalAttributes().add(string, (String)null);
        }
        if (!bl) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_DOCUMENT_TYPE_IDENTIFIER);
        }
        if (!bl2) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_PROCESS_IDENTIFIER);
        }
        if (this.m_bPerformValueChecks && !this.isValidBusinessMessage(element)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_BUSINESS_MESSAGE);
        }
        peppolSBDHDocument.setBusinessMessage(element);
        partnerIdentification = standardBusinessDocumentHeader.getDocumentIdentification();
        String string4 = partnerIdentification.getStandard();
        if (this.m_bPerformValueChecks && !this.isValidStandard(string4, element, peppolSBDHDocument.getDocumentTypeValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_STANDARD, string4, element.getNamespaceURI(), peppolSBDHDocument.getDocumentTypeValue());
        }
        String string5 = partnerIdentification.getTypeVersion();
        if (this.m_bPerformValueChecks && !this.isValidTypeVersion(string5, element, peppolSBDHDocument.getDocumentTypeValue())) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_TYPE_VERSION, string5, peppolSBDHDocument.getDocumentTypeValue());
        }
        String string6 = partnerIdentification.getType();
        if (this.m_bPerformValueChecks && !this.isValidType(string6, element)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_TYPE, string6, element.getLocalName());
        }
        object2 = partnerIdentification.getInstanceIdentifier();
        if (this.m_bPerformValueChecks && !this.isValidInstanceIdentifier((String)object2)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_INSTANCE_IDENTIFIER, object2);
        }
        string = partnerIdentification.getCreationDateAndTime();
        if (this.m_bPerformValueChecks && !this.isValidCreationDateTime((XMLOffsetDateTime)string)) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.INVALID_CREATION_DATE_TIME, String.valueOf(string));
        }
        peppolSBDHDocument.setDocumentIdentification(string4, string5, string6, (String)object2, (XMLOffsetDateTime)string);
        return peppolSBDHDocument;
    }

    @Nonnull
    public PeppolSBDHDocument extractData(@Nonnull StandardBusinessDocument standardBusinessDocument) throws PeppolSBDHDocumentReadException {
        ValueEnforcer.notNull((Object)standardBusinessDocument, (String)"StandardBusinessDocument");
        StandardBusinessDocumentHeader standardBusinessDocumentHeader = standardBusinessDocument.getStandardBusinessDocumentHeader();
        if (standardBusinessDocumentHeader == null) {
            throw new PeppolSBDHDocumentReadException(EPeppolSBDHDocumentReadError.MISSING_SBDH);
        }
        Element element = (Element)standardBusinessDocument.getAny();
        return this.extractData(standardBusinessDocumentHeader, element);
    }
}

