/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.xrechnung;

import com.helger.bdve.EValidationType;
import com.helger.bdve.artefact.IValidationArtefact;
import com.helger.bdve.artefact.ValidationArtefact;
import com.helger.bdve.en16931.EN16931Validation;
import com.helger.bdve.execute.IValidationExecutor;
import com.helger.bdve.execute.ValidationExecutorSchematron;
import com.helger.bdve.executorset.IValidationExecutorSet;
import com.helger.bdve.executorset.VESID;
import com.helger.bdve.executorset.ValidationExecutorSet;
import com.helger.bdve.executorset.ValidationExecutorSetRegistry;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XRechnungValidation {
    public static final String GROUP_ID = "de.xrechnung";
    @Deprecated
    public static final VESID VID_XRECHNUNG_CII_120 = new VESID("de.xrechnung", "cii", "1.2.0");
    @Deprecated
    public static final VESID VID_XRECHNUNG_UBL_CREDITNOTE_120 = new VESID("de.xrechnung", "ubl-creditnote", "1.2.0");
    @Deprecated
    public static final VESID VID_XRECHNUNG_UBL_INVOICE_120 = new VESID("de.xrechnung", "ubl-invoice", "1.2.0");
    @Deprecated
    public static final VESID VID_XRECHNUNG_CII_121 = new VESID("de.xrechnung", "cii", "1.2.1");
    @Deprecated
    public static final VESID VID_XRECHNUNG_UBL_CREDITNOTE_121 = new VESID("de.xrechnung", "ubl-creditnote", "1.2.1");
    @Deprecated
    public static final VESID VID_XRECHNUNG_UBL_INVOICE_121 = new VESID("de.xrechnung", "ubl-invoice", "1.2.1");
    public static final VESID VID_XRECHNUNG_CII_122 = new VESID("de.xrechnung", "cii", "1.2.2");
    public static final VESID VID_XRECHNUNG_UBL_CREDITNOTE_122 = new VESID("de.xrechnung", "ubl-creditnote", "1.2.2");
    public static final VESID VID_XRECHNUNG_UBL_INVOICE_122 = new VESID("de.xrechnung", "ubl-invoice", "1.2.2");

    @Nonnull
    private static ClassLoader _getCL() {
        return XRechnungValidation.class.getClassLoader();
    }

    private XRechnungValidation() {
    }

    @Nonnull
    private static IValidationExecutor _createXSLT(@Nonnull IReadableResource iReadableResource) {
        ValidationArtefact validationArtefact = new ValidationArtefact(EValidationType.SCHEMATRON_XSLT, XRechnungValidation._getCL(), iReadableResource);
        return new ValidationExecutorSchematron((IValidationArtefact)validationArtefact, null, null);
    }

    public static void initXRechnung(@Nonnull ValidationExecutorSetRegistry validationExecutorSetRegistry) {
        ValueEnforcer.notNull((Object)validationExecutorSetRegistry, (String)"Registry");
        IValidationExecutorSet iValidationExecutorSet = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_CII_110);
        IValidationExecutorSet iValidationExecutorSet2 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_CREDIT_NOTE_110);
        IValidationExecutorSet iValidationExecutorSet3 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_INVOICE_110);
        if (iValidationExecutorSet == null || iValidationExecutorSet2 == null || iValidationExecutorSet3 == null) {
            throw new IllegalStateException("Standard EN16931 artefacts 1.1.0 must be registered before XRechnung artefacts!");
        }
        IValidationExecutorSet iValidationExecutorSet4 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_CII_121);
        IValidationExecutorSet iValidationExecutorSet5 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_CREDIT_NOTE_121);
        IValidationExecutorSet iValidationExecutorSet6 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_INVOICE_121);
        if (iValidationExecutorSet4 == null || iValidationExecutorSet5 == null || iValidationExecutorSet6 == null) {
            throw new IllegalStateException("Standard EN16931 artefacts 1.2.1 must be registered before XRechnung artefacts!");
        }
        IValidationExecutorSet iValidationExecutorSet7 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_CII_130);
        IValidationExecutorSet iValidationExecutorSet8 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_CREDIT_NOTE_130);
        IValidationExecutorSet iValidationExecutorSet9 = validationExecutorSetRegistry.getOfID(EN16931Validation.VID_UBL_INVOICE_130);
        if (iValidationExecutorSet7 == null || iValidationExecutorSet8 == null || iValidationExecutorSet9 == null) {
            throw new IllegalStateException("Standard EN16931 artefacts 1.3.0 must be registered before XRechnung artefacts!");
        }
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet, (VESID)VID_XRECHNUNG_CII_120, (String)("XRechnung CII " + VID_XRECHNUNG_CII_120.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.0/XRechnung-CII-validation.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet2, (VESID)VID_XRECHNUNG_UBL_CREDITNOTE_120, (String)("XRechnung UBL CrediteNote " + VID_XRECHNUNG_UBL_CREDITNOTE_120.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.0/XRechnung-UBL-validation-CreditNote.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet3, (VESID)VID_XRECHNUNG_UBL_INVOICE_120, (String)("XRechnung UBL Invoice " + VID_XRECHNUNG_UBL_INVOICE_120.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.0/XRechnung-UBL-validation-Invoice.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet4, (VESID)VID_XRECHNUNG_CII_121, (String)("XRechnung CII " + VID_XRECHNUNG_CII_121.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.1/XRechnung-CII-validation.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet5, (VESID)VID_XRECHNUNG_UBL_CREDITNOTE_121, (String)("XRechnung UBL CrediteNote " + VID_XRECHNUNG_UBL_CREDITNOTE_121.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.1/XRechnung-UBL-validation-CreditNote.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet6, (VESID)VID_XRECHNUNG_UBL_INVOICE_121, (String)("XRechnung UBL Invoice " + VID_XRECHNUNG_UBL_INVOICE_121.getVersion()), (boolean)true, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.1/XRechnung-UBL-validation-Invoice.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet7, (VESID)VID_XRECHNUNG_CII_122, (String)("XRechnung CII " + VID_XRECHNUNG_CII_122.getVersion()), (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.2/XRechnung-CII-validation.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet8, (VESID)VID_XRECHNUNG_UBL_CREDITNOTE_122, (String)("XRechnung UBL CrediteNote " + VID_XRECHNUNG_UBL_CREDITNOTE_122.getVersion()), (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.2/XRechnung-UBL-validation-CreditNote.xslt"))}));
        validationExecutorSetRegistry.registerValidationExecutorSet((IValidationExecutorSet)ValidationExecutorSet.createDerived((IValidationExecutorSet)iValidationExecutorSet9, (VESID)VID_XRECHNUNG_UBL_INVOICE_122, (String)("XRechnung UBL Invoice " + VID_XRECHNUNG_UBL_INVOICE_122.getVersion()), (boolean)false, (IValidationExecutor[])new IValidationExecutor[]{XRechnungValidation._createXSLT((IReadableResource)new ClassPathResource("/schematron/1.2.2/XRechnung-UBL-validation-Invoice.xslt"))}));
    }
}

