/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EUNCodelistStatus implements IHasID<String>
{
    UNCHANGED("unchanged", '\u0000'),
    ADDED("added", '+'),
    CHANGEDNAME("changedname", '#'),
    CHANGEDCHARACTERISTICS("changedcharacteristics", '|'),
    DEPRECATED("deprecated", 'D'),
    MARKEDDELETED("markeddeleted", 'X'),
    REINSTATED("reinstated", '=');

    private final String m_sID;
    private final char m_cText;

    private EUNCodelistStatus(String string2, char c) {
        this.m_sID = string2;
        this.m_cText = c;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    @Nonempty
    public static ICommonsList<EUNCodelistStatus> getFromTextOrUnchanged(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (EUNCodelistStatus eUNCodelistStatus : EUNCodelistStatus.values()) {
                if (string.indexOf(eUNCodelistStatus.m_cText) == -1) continue;
                commonsArrayList.add((Object)eUNCodelistStatus);
            }
            if (commonsArrayList.isEmpty()) {
                throw new IllegalArgumentException("Illegal status: " + string);
            }
            return commonsArrayList;
        }
        return new CommonsArrayList((Object)UNCHANGED);
    }

    @Nonnull
    public static String getAsString(@Nonnull Iterable<EUNCodelistStatus> iterable) {
        return StringHelper.getImplodedMapped((String)",", iterable, EUNCodelistStatus::getID);
    }
}

