/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.commons.string.StringHelper;
import com.helger.masterdata.address.IPostalAddressType;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IPostalAddress
extends Serializable {
    @Nullable
    public IPostalAddressType getType();

    default public boolean hasType() {
        return this.getType() != null;
    }

    @Nullable
    public String getCountry();

    @Nullable
    public Locale getCountryLocale();

    @Nullable
    public String getCountryDisplayName(@Nonnull Locale var1);

    default public boolean hasCountry() {
        return this.getCountry() != null;
    }

    default public boolean hasCountry(@Nonnull String string) {
        return StringHelper.hasNoText((String)string) && string.equals(this.getCountry());
    }

    default public boolean hasCountry(@Nullable Locale locale) {
        return locale != null && locale.equals(this.getCountryLocale());
    }

    @Nullable
    public String getState();

    default public boolean hasState() {
        return StringHelper.hasText((String)this.getState());
    }

    @Nullable
    public String getPostalCode();

    default public boolean hasPostalCode() {
        return StringHelper.hasText((String)this.getPostalCode());
    }

    @Nullable
    public String getCity();

    default public boolean hasCity() {
        return StringHelper.hasText((String)this.getCity());
    }

    @Nullable
    public String getStreet();

    default public boolean hasStreet() {
        return StringHelper.hasText((String)this.getStreet());
    }

    @Nullable
    public String getBuildingNumber();

    default public boolean hasBuildingNumber() {
        return StringHelper.hasText((String)this.getBuildingNumber());
    }

    @Nullable
    public String getPostOfficeBox();

    default public boolean hasPostOfficeBox() {
        return StringHelper.hasText((String)this.getPostOfficeBox());
    }

    @Nullable
    public String getCareOf();

    default public boolean hasCareOf() {
        return StringHelper.hasText((String)this.getCareOf());
    }
}

