/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.address;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.IPostalAddressType;
import com.helger.masterdata.address.PostalAddressHelper;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PostalAddress
implements IPostalAddress,
ICloneable<PostalAddress> {
    private IPostalAddressType m_aAddressType;
    private String m_sCountry;
    private String m_sState;
    private String m_sPostalCode;
    private String m_sCity;
    private String m_sStreet;
    private String m_sBuildingNumber;
    private String m_sPostOfficeBox;
    private String m_sCareOf;
    private Locale m_aCountry;

    public PostalAddress() {
    }

    public PostalAddress(@Nonnull PostalAddress postalAddress) {
        ValueEnforcer.notNull((Object)postalAddress, (String)"Base");
        this.m_aAddressType = postalAddress.m_aAddressType;
        this.m_sCountry = postalAddress.m_sCountry;
        this.m_sState = postalAddress.m_sState;
        this.m_sPostalCode = postalAddress.m_sPostalCode;
        this.m_sCity = postalAddress.m_sCity;
        this.m_sStreet = postalAddress.m_sStreet;
        this.m_sBuildingNumber = postalAddress.m_sBuildingNumber;
        this.m_sPostOfficeBox = postalAddress.m_sPostOfficeBox;
        this.m_sCareOf = postalAddress.m_sCareOf;
    }

    public PostalAddress(@Nonnull IPostalAddress iPostalAddress, @Nonnull Locale locale) {
        ValueEnforcer.notNull((Object)iPostalAddress, (String)"Base");
        this.setType(iPostalAddress.getType());
        this.setCountry(iPostalAddress.getCountry(), locale);
        this.setState(iPostalAddress.getState(), locale);
        this.setPostalCode(iPostalAddress.getPostalCode());
        this.setCity(iPostalAddress.getCity(), locale);
        this.setStreet(iPostalAddress.getStreet(), locale);
        this.setBuildingNumber(iPostalAddress.getBuildingNumber());
        this.setPostOfficeBox(iPostalAddress.getPostOfficeBox(), locale);
        this.setCareOf(iPostalAddress.getCareOf(), locale);
    }

    public PostalAddress(@Nullable IPostalAddressType iPostalAddressType) {
        this.setType(iPostalAddressType);
    }

    public PostalAddress(@Nullable IPostalAddressType iPostalAddressType, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nonnull Locale locale) {
        this.setType(iPostalAddressType);
        this.setCountry(string, locale);
        this.setState(string2, locale);
        this.setPostalCode(string3);
        this.setCity(string4, locale);
        this.setStreet(string5, locale);
        this.setBuildingNumber(string6);
        this.setPostOfficeBox(string7, locale);
        this.setCareOf(string8, locale);
    }

    @Override
    @Nullable
    public IPostalAddressType getType() {
        return this.m_aAddressType;
    }

    @Nonnull
    public EChange setType(@Nullable IPostalAddressType iPostalAddressType) {
        if (EqualsHelper.equals((Object)this.m_aAddressType, (Object)iPostalAddressType)) {
            return EChange.UNCHANGED;
        }
        this.m_aAddressType = iPostalAddressType;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCountry() {
        return this.m_sCountry;
    }

    @Override
    @Nullable
    public String getCountryDisplayName(@Nonnull Locale locale) {
        Locale locale2 = this.getCountryLocale();
        return locale2 == null ? null : locale2.getDisplayCountry(locale);
    }

    @Override
    @Nullable
    public Locale getCountryLocale() {
        Locale locale = this.m_aCountry;
        if (locale == null && this.m_sCountry != null) {
            this.m_aCountry = locale = CountryCache.getInstance().getCountry(this.m_sCountry);
        }
        return locale;
    }

    @Nonnull
    public EChange setCountry(@Nullable Locale locale, @Nonnull Locale locale2) {
        return this.setCountry(locale == null ? null : locale.getCountry(), locale2);
    }

    @Nonnull
    public EChange setCountry(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedCountry(string, locale);
        if (EqualsHelper.equals((Object)this.m_sCountry, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sCountry = string2 == null ? null : string2.intern();
        this.m_aCountry = null;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getState() {
        return this.m_sState;
    }

    @Nonnull
    public EChange setState(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedState(string, locale);
        if (EqualsHelper.equals((Object)this.m_sState, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sState = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getPostalCode() {
        return this.m_sPostalCode;
    }

    @Nonnull
    public EChange setPostalCode(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals((Object)this.m_sPostalCode, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sPostalCode = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCity() {
        return this.m_sCity;
    }

    @Nonnull
    public EChange setCity(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedCity(string, locale);
        if (EqualsHelper.equals((Object)this.m_sCity, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sCity = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getStreet() {
        return this.m_sStreet;
    }

    @Nonnull
    public EChange setStreet(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedStreet(string, locale);
        if (EqualsHelper.equals((Object)this.m_sStreet, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sStreet = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getBuildingNumber() {
        return this.m_sBuildingNumber;
    }

    @Nonnull
    public EChange setBuildingNumber(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sBuildingNumber, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sBuildingNumber = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getPostOfficeBox() {
        return this.m_sPostOfficeBox;
    }

    @Nonnull
    public EChange setPostOfficeBox(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedPOBox(string, locale);
        if (EqualsHelper.equals((Object)this.m_sPostOfficeBox, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sPostOfficeBox = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getCareOf() {
        return this.m_sCareOf;
    }

    @Nonnull
    public EChange setCareOf(@Nullable String string, @Nonnull Locale locale) {
        String string2 = PostalAddressHelper.getUnifiedCareOf(string, locale);
        if (EqualsHelper.equals((Object)this.m_sCareOf, (Object)string2)) {
            return EChange.UNCHANGED;
        }
        this.m_sCareOf = string2;
        return EChange.CHANGED;
    }

    @Nonnull
    public PostalAddress getClone() {
        return new PostalAddress(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PostalAddress postalAddress = (PostalAddress)object;
        return EqualsHelper.equals((Object)this.m_aAddressType, (Object)postalAddress.m_aAddressType) && EqualsHelper.equals((Object)this.m_sCountry, (Object)postalAddress.m_sCountry) && EqualsHelper.equals((Object)this.m_sState, (Object)postalAddress.m_sState) && EqualsHelper.equals((Object)this.m_sPostalCode, (Object)postalAddress.m_sPostalCode) && EqualsHelper.equals((Object)this.m_sCity, (Object)postalAddress.m_sCity) && EqualsHelper.equals((Object)this.m_sStreet, (Object)postalAddress.m_sStreet) && EqualsHelper.equals((Object)this.m_sBuildingNumber, (Object)postalAddress.m_sBuildingNumber) && EqualsHelper.equals((Object)this.m_sPostOfficeBox, (Object)postalAddress.m_sPostOfficeBox) && EqualsHelper.equals((Object)this.m_sCareOf, (Object)postalAddress.m_sCareOf);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aAddressType).append((Object)this.m_sCountry).append((Object)this.m_sState).append((Object)this.m_sPostalCode).append((Object)this.m_sCity).append((Object)this.m_sStreet).append((Object)this.m_sBuildingNumber).append((Object)this.m_sPostOfficeBox).append((Object)this.m_sCareOf).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("addressType", (Object)this.m_aAddressType).appendIfNotNull("country", (Object)this.m_sCountry).appendIfNotNull("state", (Object)this.m_sState).appendIfNotNull("postalCode", (Object)this.m_sPostalCode).appendIfNotNull("city", (Object)this.m_sCity).appendIfNotNull("street", (Object)this.m_sStreet).appendIfNotNull("buildingNumber", (Object)this.m_sBuildingNumber).appendIfNotNull("pobox", (Object)this.m_sPostOfficeBox).appendIfNotNull("careOf", (Object)this.m_sCareOf).getToString();
    }
}

