/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.company;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.address.PostalAddress;
import com.helger.masterdata.company.ICompany;
import com.helger.masterdata.company.ICompanySite;
import com.helger.masterdata.email.ExtendedEmailAddress;
import com.helger.masterdata.email.IExtendedEmailAddress;
import com.helger.masterdata.telephone.ITelephoneNumber;
import com.helger.masterdata.telephone.TelephoneNumber;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CompanySite
implements ICompanySite {
    public static final ObjectType OT = new ObjectType("company-site");
    public static final boolean DEFAULT_DELETABLE = true;
    public static final boolean DEFAULT_VIRTUALSITE = false;
    private final String m_sID;
    private final ICompany m_aCompany;
    private String m_sDisplayName;
    private String m_sLongName;
    private boolean m_bIsDeletable = true;
    private boolean m_bIsVirtualSite = false;
    private IPostalAddress m_aAddress = new PostalAddress();
    private ITelephoneNumber m_aTelNo = new TelephoneNumber();
    private ITelephoneNumber m_aFaxNo = new TelephoneNumber();
    private IExtendedEmailAddress m_aEmailAddress = new ExtendedEmailAddress();

    public CompanySite(@Nonnull ICompany iCompany) {
        this(GlobalIDFactory.getNewPersistentStringID(), iCompany);
    }

    public CompanySite(@Nonnull @Nonempty String string, @Nonnull ICompany iCompany) {
        this.m_sID = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ID");
        this.m_aCompany = (ICompany)ValueEnforcer.notNull((Object)iCompany, (String)"Company");
    }

    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    public ICompany getCompany() {
        return this.m_aCompany;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public EChange setDisplayName(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sDisplayName, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getLongName() {
        return this.m_sLongName;
    }

    @Nonnull
    public EChange setLongName(@Nullable String string) {
        if (EqualsHelper.equals((Object)this.m_sLongName, (Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_sLongName = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean isDeletable() {
        return this.m_bIsDeletable;
    }

    @Nonnull
    public EChange setDeletable(boolean bl) {
        if (this.m_bIsDeletable == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bIsDeletable = bl;
        return EChange.CHANGED;
    }

    @Override
    public boolean isVirtualSite() {
        return this.m_bIsVirtualSite;
    }

    @Nonnull
    public EChange setVirtualSite(boolean bl) {
        if (this.m_bIsVirtualSite == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bIsVirtualSite = bl;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public IPostalAddress getAddress() {
        return this.m_aAddress;
    }

    @Nonnull
    public EChange setAddress(@Nonnull IPostalAddress iPostalAddress) {
        ValueEnforcer.notNull((Object)iPostalAddress, (String)"Address");
        if (this.m_aAddress.equals(iPostalAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_aAddress = iPostalAddress;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public ITelephoneNumber getDefaultTelNo() {
        return this.m_aTelNo;
    }

    @Nonnull
    public EChange setDefaultTelNo(@Nonnull ITelephoneNumber iTelephoneNumber) {
        ValueEnforcer.notNull((Object)iTelephoneNumber, (String)"TelNo");
        if (this.m_aTelNo.equals(iTelephoneNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_aTelNo = iTelephoneNumber;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public ITelephoneNumber getDefaultFaxNo() {
        return this.m_aFaxNo;
    }

    @Nonnull
    public EChange setDefaultFaxNo(@Nonnull ITelephoneNumber iTelephoneNumber) {
        ValueEnforcer.notNull((Object)iTelephoneNumber, (String)"FaxNo");
        if (this.m_aFaxNo.equals(iTelephoneNumber)) {
            return EChange.UNCHANGED;
        }
        this.m_aFaxNo = iTelephoneNumber;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public IExtendedEmailAddress getDefaultEmailAddress() {
        return this.m_aEmailAddress;
    }

    @Nonnull
    public EChange setDefaultEmailAddress(@Nonnull IExtendedEmailAddress iExtendedEmailAddress) {
        ValueEnforcer.notNull((Object)iExtendedEmailAddress, (String)"EmailAddress");
        if (this.m_aEmailAddress.equals(iExtendedEmailAddress)) {
            return EChange.UNCHANGED;
        }
        this.m_aEmailAddress = iExtendedEmailAddress;
        return EChange.CHANGED;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CompanySite companySite = (CompanySite)object;
        return this.m_sID.equals(companySite.m_sID);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ID", (Object)this.m_sID).append("companyID", this.m_aCompany.getID()).appendIfNotNull("displayName", (Object)this.m_sDisplayName).appendIfNotNull("longName", (Object)this.m_sLongName).append("virtual", this.m_bIsVirtualSite).appendIfNotNull("address", (Object)this.m_aAddress).appendIfNotNull("telNo", (Object)this.m_aTelNo).appendIfNotNull("faxNo", (Object)this.m_aFaxNo).appendIfNotNull("email", (Object)this.m_aEmailAddress).getToString();
    }
}

