/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currency;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currency.EDecimalSeparator;
import com.helger.masterdata.currency.EGroupingSeparator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PerCurrencySettings {
    private final int m_nScale;
    private final String m_sCurrencyPattern;
    private final String m_sValuePattern;
    private final DecimalFormat m_aCurrencyFormat;
    private final DecimalFormat m_aValueFormat;
    private final DecimalFormatSymbols m_aDFS;
    private RoundingMode m_eRoundingMode;
    private final EDecimalSeparator m_eDecimalSep;
    private final EGroupingSeparator m_eGroupingSep;

    public PerCurrencySettings(@Nonnull ECurrency eCurrency) {
        String string;
        Currency currency;
        Locale locale2 = (Locale)eCurrency.matchingLocales().findFirst(locale -> locale.getLanguage().length() > 0);
        if (locale2 == null) {
            locale2 = (Locale)eCurrency.matchingLocales().getFirst();
        }
        this.m_nScale = (currency = eCurrency.getAsCurrency()) == null ? 2 : currency.getDefaultFractionDigits();
        this.m_aCurrencyFormat = (DecimalFormat)NumberFormat.getCurrencyInstance(locale2);
        this.m_aCurrencyFormat.setMaximumFractionDigits(this.m_nScale);
        this.m_aDFS = this.m_aCurrencyFormat.getDecimalFormatSymbols();
        this.m_sCurrencyPattern = string = this.m_aCurrencyFormat.toPattern();
        String string2 = string;
        string2 = StringHelper.removeAll((String)string2, (String)"\u00a4 ");
        string2 = StringHelper.removeAll((String)string2, (String)" \u00a4");
        string2 = StringHelper.removeAll((String)string2, (String)"\u00a4");
        this.m_sValuePattern = string2 = StringHelper.removeAll((String)string2, (char)'\u00a0');
        this.m_aValueFormat = new DecimalFormat(this.m_sValuePattern, this.m_aDFS);
        this.m_eRoundingMode = null;
        this.m_eDecimalSep = EDecimalSeparator.getFromCharOrNull(this.m_aDFS.getDecimalSeparator());
        this.m_eGroupingSep = EGroupingSeparator.getFromCharOrNull(this.m_aDFS.getGroupingSeparator());
    }

    @Nonnegative
    public int getScale() {
        return this.m_nScale;
    }

    @Nonnull
    @Nonempty
    public String getCurrencyPattern() {
        return this.m_sCurrencyPattern;
    }

    @Nonnull
    @Nonempty
    public String getValuePattern() {
        return this.m_sValuePattern;
    }

    @Nonnull
    public DecimalFormat getCurrencyFormat() {
        return (DecimalFormat)this.m_aCurrencyFormat.clone();
    }

    @Nonnull
    public String getCurrencyFormatted(@Nonnull BigDecimal bigDecimal) {
        return this.getCurrencyFormat().format(bigDecimal);
    }

    @Nonnull
    public String getCurrencyFormatted(@Nonnull BigDecimal bigDecimal, @Nonnegative int n) {
        DecimalFormat decimalFormat = this.getCurrencyFormat();
        decimalFormat.setMaximumFractionDigits(n);
        return decimalFormat.format(bigDecimal);
    }

    @Nonnull
    public DecimalFormat getValueFormat() {
        return (DecimalFormat)this.m_aValueFormat.clone();
    }

    @Nonnull
    public String getValueFormatted(@Nonnull BigDecimal bigDecimal) {
        return this.getValueFormat().format(bigDecimal);
    }

    @Nonnull
    public String getValueFormatted(@Nonnull BigDecimal bigDecimal, @Nonnegative int n) {
        DecimalFormat decimalFormat = this.getValueFormat();
        decimalFormat.setMaximumFractionDigits(n);
        return decimalFormat.format(bigDecimal);
    }

    public void setMinimumFractionDigits(@Nonnegative int n) {
        ValueEnforcer.isGE0((int)n, (String)"Decimals");
        this.m_aCurrencyFormat.setMinimumFractionDigits(n);
        this.m_aValueFormat.setMinimumFractionDigits(n);
    }

    @Nonnull
    public String getCurrencySymbol() {
        return this.m_aDFS.getCurrencySymbol();
    }

    @Nonnull
    public RoundingMode getRoundingMode() {
        return this.m_eRoundingMode != null ? this.m_eRoundingMode : CurrencyHelper.DEFAULT_ROUNDING_MODE;
    }

    public void setRoundingMode(@Nullable RoundingMode roundingMode) {
        this.m_eRoundingMode = roundingMode;
    }

    @Nullable
    public EDecimalSeparator getDecimalSeparator() {
        return this.m_eDecimalSep;
    }

    @Nullable
    public EGroupingSeparator getGroupingSeparator() {
        return this.m_eGroupingSep;
    }
}

