/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currencyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.math.MathHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.ECurrency;
import com.helger.masterdata.currencyvalue.ICurrencyValue;
import com.helger.masterdata.currencyvalue.IMutableCurrencyValue;
import java.math.BigDecimal;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CurrencyValue
implements IMutableCurrencyValue {
    private ECurrency m_eCurrency;
    private BigDecimal m_aValue;

    public CurrencyValue(@Nonnull ICurrencyValue iCurrencyValue) {
        this(iCurrencyValue.getCurrency(), iCurrencyValue.getValue());
    }

    public CurrencyValue(@Nonnull ECurrency eCurrency) {
        this(eCurrency, BigDecimal.ZERO);
    }

    public CurrencyValue(@Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        this.setCurrency(eCurrency);
        this.setValue(bigDecimal);
    }

    @Override
    @Nonnull
    public ECurrency getCurrency() {
        return this.m_eCurrency;
    }

    @Override
    @Nonnull
    public EChange setCurrency(@Nonnull ECurrency eCurrency) {
        ValueEnforcer.notNull((Object)((Object)eCurrency), (String)"Currency");
        if (eCurrency.equals((Object)this.m_eCurrency)) {
            return EChange.UNCHANGED;
        }
        this.m_eCurrency = eCurrency;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public BigDecimal getValue() {
        return this.m_aValue;
    }

    @Override
    @Nonnull
    public EChange setValue(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        if (EqualsHelper.equals((Object)bigDecimal, (Object)this.m_aValue)) {
            return EChange.UNCHANGED;
        }
        this.m_aValue = bigDecimal;
        return EChange.CHANGED;
    }

    @Override
    public void addValue(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        this.m_aValue = this.m_aValue.add(bigDecimal);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CurrencyValue getAdded(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        if (MathHelper.isEQ0((BigDecimal)bigDecimal)) {
            return this;
        }
        return new CurrencyValue(this.getCurrency(), this.getValue().add(bigDecimal));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CurrencyValue getSubtracted(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        if (MathHelper.isEQ0((BigDecimal)bigDecimal)) {
            return this;
        }
        return new CurrencyValue(this.getCurrency(), this.getValue().subtract(bigDecimal));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CurrencyValue getMultiplied(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        if (MathHelper.isEQ1((BigDecimal)bigDecimal)) {
            return this;
        }
        return new CurrencyValue(this.getCurrency(), this.getValue().multiply(bigDecimal));
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CurrencyValue getDivided(@Nonnull BigDecimal bigDecimal) {
        ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        if (MathHelper.isEQ1((BigDecimal)bigDecimal)) {
            return this;
        }
        ECurrency eCurrency = this.getCurrency();
        return new CurrencyValue(eCurrency, CurrencyHelper.getDivided(eCurrency, this.getValue(), bigDecimal));
    }

    @Nonnull
    public CurrencyValue getClone() {
        return new CurrencyValue(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CurrencyValue currencyValue = (CurrencyValue)object;
        return this.m_eCurrency.equals((Object)currencyValue.m_eCurrency) && EqualsHelper.equals((Object)this.m_aValue, (Object)currencyValue.m_aValue);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eCurrency).append((Object)this.m_aValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("currency", (Enum)this.m_eCurrency).append("value", (Object)this.m_aValue).getToString();
    }

    @Nonnull
    public static IMutableCurrencyValue fromCurrencyFormattedString(@Nonnull String string, @Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        return new CurrencyValue(eCurrency, CurrencyHelper.parseCurrencyFormat(eCurrency, string, bigDecimal));
    }

    @Nonnull
    public static IMutableCurrencyValue fromValueFormattedString(@Nonnull String string, @Nonnull ECurrency eCurrency, @Nonnull BigDecimal bigDecimal) {
        return new CurrencyValue(eCurrency, CurrencyHelper.parseValueFormat(eCurrency, string, bigDecimal));
    }
}

