/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.currencyvalue;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.math.MathHelper;
import com.helger.masterdata.currency.CurrencyHelper;
import com.helger.masterdata.currency.IHasCurrency;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@MustImplementEqualsAndHashcode
public interface ICurrencyValue
extends IHasCurrency,
Serializable {
    @Nonnull
    public BigDecimal getValue();

    @Deprecated
    default public boolean isLowerThanZero() {
        return this.isLT0();
    }

    default public boolean isLT0() {
        return MathHelper.isLT0((BigDecimal)this.getValue());
    }

    default public boolean isLE0() {
        return MathHelper.isLE0((BigDecimal)this.getValue());
    }

    default public boolean isEQ0() {
        return MathHelper.isEQ0((BigDecimal)this.getValue());
    }

    default public boolean isNE0() {
        return MathHelper.isNE0((BigDecimal)this.getValue());
    }

    @Deprecated
    default public boolean isGreaterThanZero() {
        return this.isGT0();
    }

    default public boolean isGT0() {
        return MathHelper.isGT0((BigDecimal)this.getValue());
    }

    default public boolean isGE0() {
        return MathHelper.isGE0((BigDecimal)this.getValue());
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getAdded(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getAdded(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getAdded(MathHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getSubtracted(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getSubtracted(long l) {
        if (l == 0L) {
            return this;
        }
        return this.getSubtracted(MathHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getMultiplied(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getMultiplied(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getMultiplied(MathHelper.toBigDecimal((long)l));
    }

    @Nonnull
    @CheckReturnValue
    public ICurrencyValue getDivided(@Nonnull BigDecimal var1);

    @Nonnull
    @CheckReturnValue
    default public ICurrencyValue getDivided(long l) {
        if (l == 1L) {
            return this;
        }
        return this.getDivided(MathHelper.toBigDecimal((long)l));
    }

    @Nonnull
    default public String getCurrencyFormatted() {
        return CurrencyHelper.getCurrencyFormatted(this.getCurrency(), this.getValue());
    }

    @Nonnull
    default public String getCurrencyFormatted(@Nonnegative int n) {
        return CurrencyHelper.getCurrencyFormatted(this.getCurrency(), this.getValue(), n);
    }

    @Nonnull
    default public String getValueFormatted() {
        return CurrencyHelper.getValueFormatted(this.getCurrency(), this.getValue());
    }

    @Nonnull
    default public String getValueFormatted(@Nonnegative int n) {
        return CurrencyHelper.getValueFormatted(this.getCurrency(), this.getValue(), n);
    }
}

