/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.email;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.email.EmailAddressHelper;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.masterdata.email.IEmailAddressType;
import com.helger.masterdata.email.IExtendedEmailAddress;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ExtendedEmailAddress
implements IExtendedEmailAddress,
ICloneable<ExtendedEmailAddress> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedEmailAddress.class);
    private IEmailAddressType m_aAddressType;
    private String m_sAddress;
    private String m_sPersonal;

    public ExtendedEmailAddress() {
    }

    public ExtendedEmailAddress(@Nonnull ExtendedEmailAddress extendedEmailAddress) {
        ValueEnforcer.notNull((Object)extendedEmailAddress, (String)"Base");
        this.m_aAddressType = extendedEmailAddress.m_aAddressType;
        this.m_sAddress = extendedEmailAddress.m_sAddress;
        this.m_sPersonal = extendedEmailAddress.m_sPersonal;
    }

    public ExtendedEmailAddress(@Nonnull IExtendedEmailAddress iExtendedEmailAddress) {
        ValueEnforcer.notNull((Object)iExtendedEmailAddress, (String)"Base");
        this.setType(iExtendedEmailAddress.getType());
        this.setAddress(iExtendedEmailAddress.getAddress());
        this.setPersonal(iExtendedEmailAddress.getPersonal());
    }

    public ExtendedEmailAddress(@Nullable IEmailAddressType iEmailAddressType, @Nonnull String string) {
        this(iEmailAddressType, string, null);
    }

    public ExtendedEmailAddress(@Nullable IEmailAddressType iEmailAddressType, @Nonnull String string, @Nullable String string2) {
        this.setType(iEmailAddressType);
        this.setAddress(string);
        this.setPersonal(string2);
    }

    @Override
    @Nullable
    public IEmailAddressType getType() {
        return this.m_aAddressType;
    }

    @Nonnull
    public final EChange setType(@Nullable IEmailAddressType iEmailAddressType) {
        if (EqualsHelper.equals((Object)iEmailAddressType, (Object)this.m_aAddressType)) {
            return EChange.UNCHANGED;
        }
        this.m_aAddressType = iEmailAddressType;
        return EChange.CHANGED;
    }

    @Nonnull
    public String getAddress() {
        return this.m_sAddress;
    }

    @Nonnull
    public final EChange setAddress(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Address");
        String string2 = EmailAddressHelper.getUnifiedEmailAddress((String)string);
        if (EqualsHelper.equals((Object)string2, (Object)this.m_sAddress)) {
            return EChange.UNCHANGED;
        }
        if (string2 != null && !EmailAddressHelper.isValid((String)string2)) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Found an illegal email address: '" + string2 + "'");
            }
            return EChange.UNCHANGED;
        }
        this.m_sAddress = string2;
        return EChange.CHANGED;
    }

    @Nullable
    public String getPersonal() {
        return this.m_sPersonal;
    }

    @Nonnull
    public final EChange setPersonal(@Nullable String string) {
        String string2 = string;
        if (EqualsHelper.equals((Object)string2, (Object)this.m_sPersonal)) {
            return EChange.UNCHANGED;
        }
        this.m_sPersonal = string2;
        return EChange.CHANGED;
    }

    @Nonnull
    public String getDisplayName() {
        if (this.m_sAddress == null) {
            return "";
        }
        if (StringHelper.hasText((String)this.m_sPersonal)) {
            return this.m_sPersonal + " <" + this.m_sAddress + ">";
        }
        return this.m_sAddress;
    }

    @Nonnull
    public ExtendedEmailAddress getClone() {
        return new ExtendedEmailAddress(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExtendedEmailAddress extendedEmailAddress = (ExtendedEmailAddress)object;
        return EqualsHelper.equals((Object)this.m_aAddressType, (Object)extendedEmailAddress.m_aAddressType) && EqualsHelper.equals((Object)this.m_sAddress, (Object)extendedEmailAddress.m_sAddress) && EqualsHelper.equals((Object)this.m_sPersonal, (Object)extendedEmailAddress.m_sPersonal);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aAddressType).append((Object)this.m_sAddress).append((Object)this.m_sPersonal).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).appendIfNotNull("addressType", (Object)this.m_aAddressType).appendIfNotNull("address", (Object)this.m_sAddress).appendIfNotNull("personal", (Object)this.m_sPersonal).getToString();
    }

    @Nullable
    public static ExtendedEmailAddress createOnDemand(@Nullable String string) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        ExtendedEmailAddress extendedEmailAddress = new ExtendedEmailAddress();
        extendedEmailAddress.setAddress(string);
        return extendedEmailAddress;
    }
}

