/*
 * Decompiled with CFR 0.152.
 */
package com.helger.masterdata.exchangeratio;

import com.helger.masterdata.exchangeratio.ExchangeRatio;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExchangeRatioMicroTypeConverter
implements IMicroTypeConverter<ExchangeRatio> {
    private static final IMicroQName ATTR_DATE = new MicroQName("date");
    private static final IMicroQName ATTR_RATIO = new MicroQName("ratio");

    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull ExchangeRatio exchangeRatio, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttributeWithConversion(ATTR_DATE, (Object)exchangeRatio.getDate());
        microElement.setAttributeWithConversion(ATTR_RATIO, (Object)exchangeRatio.getRatio());
        return microElement;
    }

    @Nonnull
    public ExchangeRatio convertToNative(@Nonnull IMicroElement iMicroElement) {
        LocalDate localDate = (LocalDate)iMicroElement.getAttributeValueWithConversion(ATTR_DATE, LocalDate.class);
        BigDecimal bigDecimal = (BigDecimal)iMicroElement.getAttributeValueWithConversion(ATTR_RATIO, BigDecimal.class);
        return new ExchangeRatio(localDate, bigDecimal);
    }
}

